/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.mediator.resolver;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.tooling.client.api.value.resolver.ValueResolverFailure;
import org.mule.tooling.client.api.value.resolver.ValueResolverResult;
import org.mule.tooling.client.internal.session.cache.DeclarationMetadataCache;
import org.mule.tooling.client.internal.session.filter.MetadataKeyFilter;
import org.mule.tooling.client.internal.session.filter.exception.InvalidLevelValueException;
import org.mule.tooling.client.internal.session.filter.exception.MissingLevelException;
import org.mule.tooling.client.internal.session.filter.exception.UnknownLevelValueException;
import org.mule.tooling.client.internal.session.mediator.resolver.SessionFunction;
import org.mule.tooling.client.internal.session.mediator.resolver.SkeletalValueResolver;
import org.mule.tooling.client.internal.session.mediator.resolver.ValuesResolver;
import org.mule.tooling.client.internal.utils.ValueResolverUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataKeyResolver
extends SkeletalValueResolver<MetadataResult<MetadataKeysContainer>>
implements ValuesResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataKeyResolver.class);
    private final ComponentElementDeclaration<?> elementDeclaration;
    private final MetadataKeyPartModelProperty metadataKeyPartModelProperty;
    private final DeclarationMetadataCache metadataCache;
    private final MetadataKeyFilter metadataKeyFilter;

    public MetadataKeyResolver(SessionFunction<MetadataResult<MetadataKeysContainer>> sessionFunction, boolean ignoreCache, ComponentElementDeclaration<?> elementDeclaration, MetadataKeyPartModelProperty metadataKeyPartModelProperty, DeclarationMetadataCache metadataCache, MetadataKeyFilter metadataKeyFilter) {
        super(sessionFunction, ignoreCache);
        this.elementDeclaration = elementDeclaration;
        this.metadataKeyPartModelProperty = metadataKeyPartModelProperty;
        this.metadataCache = metadataCache;
        this.metadataKeyFilter = metadataKeyFilter;
    }

    @Override
    public ValueResolverResult resolve(ParameterizedModel parameterizedModel, ParameterModel parameterModel, String parameterName) {
        Set<MetadataKey> requestedLevelKeys;
        block6: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolving values using Metadata Keys mechanism for parameter: '{}' on element: '{}' for declared for extension: '{}'", new Object[]{parameterName, this.elementDeclaration.getName(), this.elementDeclaration.getDeclaringExtension()});
            }
            EnrichableModel enrichableModel = (EnrichableModel)parameterizedModel;
            boolean partialTypeKeyResolver = enrichableModel.getModelProperty(TypeResolversInformationModelProperty.class).map(TypeResolversInformationModelProperty::isPartialTypeKeyResolver).orElse(false);
            Callable<MetadataResult<MetadataKeysContainer>> keysCallable = () -> (MetadataResult)this.sessionFunction.apply((runtimeToolingService, sessionId) -> runtimeToolingService.getComponentMetadataKeys(sessionId, this.elementDeclaration, this.ignoreCache));
            MetadataResult<MetadataKeysContainer> metadataKeysContainerMetadataResult = partialTypeKeyResolver ? this.metadataCache.getMetadataKeysPartialFetch(parameterizedModel, this.elementDeclaration, keysCallable, this.ignoreCache) : this.metadataCache.getMetadataKeys(this.elementDeclaration, keysCallable, this.ignoreCache);
            if (!metadataKeysContainerMetadataResult.isSuccess()) {
                MetadataFailure metadataFailure = (MetadataFailure)metadataKeysContainerMetadataResult.getFailures().stream().findFirst().get();
                return ValueResolverResult.failure((ValueResolverFailure)new ValueResolverFailure(metadataFailure.getMessage(), metadataFailure.getReason(), this.transformMetadataKeyFailureCode(metadataFailure)));
            }
            Set<MetadataKey> metadataKeys = ((MetadataKeysContainer)metadataKeysContainerMetadataResult.get()).getKeysByCategory().values().stream().findFirst().orElse(Collections.emptySet());
            requestedLevelKeys = Collections.emptySet();
            try {
                requestedLevelKeys = this.metadataKeyFilter.filter(parameterName, (ParameterizedElementDeclaration)this.elementDeclaration, metadataKeys);
            }
            catch (MissingLevelException e) {
                return this.missingActingParametersFailure(e.getMissingParameterName());
            }
            catch (InvalidLevelValueException e) {
                return this.invalidActingParameterFailure(e.getTargetSelector(), e.getMessage());
            }
            catch (UnknownLevelValueException e) {
                if (!this.metadataKeyPartModelProperty.isProvidedByKeyResolver() || this.metadataKeyPartModelProperty.getOrder() <= 1) break block6;
                return this.unknownActingParametersFailure(e.getParameterName(), e.getParameterValue());
            }
        }
        return ValueResolverUtils.toValueResolverResult(requestedLevelKeys);
    }

    private String transformMetadataKeyFailureCode(MetadataFailure metadataFailure) {
        FailureCode failureCode = metadataFailure.getFailureCode();
        if (failureCode == null) {
            return null;
        }
        if (failureCode.equals((Object)FailureCode.INVALID_METADATA_KEY)) {
            return "INVALID_ACTING_PARAMETER_VALUES";
        }
        return failureCode.getName();
    }
}

