/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.api.operation;

import com.mulesoft.connectivity.mule.api.Content;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResultError {
    public static final String KIND_UNCHECKED = "__UNCHECKED";
    private final String description;
    private final Object value;
    private final Content content;
    private final ResultError cause;
    private final String kind;
    private final List<String> categories;
    private final Map<String, Object> additionalProperties;

    private ResultError(String description, Object value, Content content, ResultError cause, String kind, List<String> categories, Map<String, Object> additionalProperties) {
        this.description = description;
        this.value = Objects.requireNonNull(value, "'value' cannot be null");
        this.content = content;
        this.cause = cause;
        this.kind = Objects.requireNonNull(kind, "'kind' cannot be null");
        this.categories = new ArrayList<String>((Collection)Objects.requireNonNull(categories, "'categories' cannot be null"));
        this.additionalProperties = additionalProperties == null ? Collections.EMPTY_MAP : new HashMap<String, Object>(additionalProperties);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Object getValue() {
        return this.value;
    }

    public String getKind() {
        return this.kind;
    }

    public Optional<Content> getContent() {
        return Optional.ofNullable(this.content);
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public Optional<Object> get(String property) {
        return Optional.ofNullable(this.additionalProperties.get(property));
    }

    public Optional<ResultError> getCause() {
        return Optional.ofNullable(this.cause);
    }

    public static ResultError error(String description, Object value, Content content, ResultError cause, String kind, List<String> categories, Map<String, Object> additionalProperties) {
        return new ResultError(description, value, content, cause, kind, categories, additionalProperties);
    }

    public static ResultError error(Object value, Content content, String kind, List<String> categories) {
        return ResultError.error(null, value, content, null, kind, categories, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResultError:");
        if (this.description != null) {
            sb.append("description='").append(this.description).append("', ");
        }
        sb.append("value=").append(this.value).append(", kind='").append(this.kind).append("', categories=").append(this.categories);
        if (!this.additionalProperties.isEmpty()) {
            sb.append(", additionalProperties=").append(this.additionalProperties);
        }
        return sb.toString();
    }
}

