/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.ApplicationModelResolver;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.annotators.AnnotatorsRegistry;
import org.mule.datasense.impl.phases.annotators.FunctionBindingsAnnotator;
import org.mule.datasense.impl.phases.annotators.GlobalBindingsAnnotator;
import org.mule.datasense.impl.phases.annotators.InfoAnnotator;
import org.mule.datasense.impl.phases.annotators.MUnitDeclarationAnnotator;
import org.mule.datasense.impl.phases.annotators.MessageProcessorTypeDeclarationAnnotator;
import org.mule.datasense.impl.phases.annotators.OperationCallAnnotator;
import org.mule.datasense.impl.phases.annotators.TransformAnnotator;
import org.mule.datasense.impl.phases.annotators.TypeResolverAnnotator;
import org.mule.datasense.impl.phases.annotators.UnknownTypeResolverAnnotator;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MuleApplicationNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParser;
import org.mule.datasense.impl.phases.builder.MuleAstParserContext;
import org.mule.datasense.impl.phases.builder.MuleFlowNodeBuilder;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.AstTyping;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.util.AstUtils;
import org.mule.datasenseapi.api.DataSenseResolutionScope;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSenseApplicationModel {
    private static final transient Logger logger = LoggerFactory.getLogger(DataSenseApplicationModel.class);
    private final DataSenseResolutionScope dataSenseResolutionScope;
    private final DataSenseProvider dataSenseProvider;
    private final AstNotification astNotification;
    private final ApplicationModel applicationModel;
    private MuleApplicationNode muleApplicationNode;
    private DataSenseProviderResolver dataSenseProviderResolver;
    private final TypeResolverRegistry typeResolverRegistry;

    public DataSenseApplicationModel(DataSenseResolutionScope dataSenseResolutionScope, ApplicationModel applicationModel, DataSenseProvider dataSenseProvider, TypeResolverRegistry typeResolverRegistry, AstNotification astNotification) {
        this.dataSenseResolutionScope = dataSenseResolutionScope;
        this.applicationModel = applicationModel;
        this.dataSenseProvider = dataSenseProvider;
        this.typeResolverRegistry = typeResolverRegistry;
        this.astNotification = astNotification;
    }

    public void build() {
        ApplicationModelResolver applicationModelResolver = new ApplicationModelResolver(this.applicationModel);
        this.dataSenseProviderResolver = new DataSenseProviderResolver(this.dataSenseProvider, applicationModelResolver, this.astNotification);
        ArtifactAst rootComponentModel = this.applicationModel.getMuleApplicationModel();
        this.parse(rootComponentModel);
    }

    private void parse(ArtifactAst rootComponentModel) {
        MuleAstParser muleAstParser = new MuleAstParser();
        MuleAstParserContext visitorContext = new MuleAstParserContext(this.applicationModel, this.dataSenseProvider, componentModel -> {
            ComponentIdentifier identifier = componentModel.getIdentifier();
            return Optional.ofNullable(this.typeResolverRegistry.get(identifier).flatMap(TypeResolver::getComponentModelType).orElseGet(() -> {
                if (componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.SOURCE)) {
                    return ComponentModelType.MESSAGE_SOURCE_NODE;
                }
                if (componentModel.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.OPERATION)) {
                    return ComponentModelType.MESSAGE_PROCESSOR_NODE;
                }
                return null;
            }));
        }, this.dataSenseResolutionScope, this.typeResolverRegistry);
        MuleApplicationNodeBuilder muleApplicationNodeBuilder = new MuleApplicationNodeBuilder(DefaultDataSense.COMPONENT_IDENTIFIER_MULE);
        muleApplicationNodeBuilder.name("app");
        rootComponentModel.topLevelComponentsStream().map(innerComponentModel -> muleAstParser.parse((ComponentAst)innerComponentModel, visitorContext)).filter(Optional::isPresent).map(Optional::get).filter(astNodeBuilder -> astNodeBuilder instanceof MuleFlowNodeBuilder).map(astNodeBuilder -> (MuleFlowNodeBuilder)astNodeBuilder).forEach(muleApplicationNodeBuilder::muleFlow);
        this.muleApplicationNode = muleApplicationNodeBuilder.build();
        AnnotatorsRegistry annotatorsRegistry = new AnnotatorsRegistry();
        annotatorsRegistry.add(new InfoAnnotator());
        AstTyping astTyping = new AstTyping(annotatorsRegistry, this.typeResolverRegistry);
        astTyping.annotate(this.muleApplicationNode, this.dataSenseProviderResolver, this.astNotification);
    }

    private AnnotatorsRegistry createAnnotatorsRegistry() {
        AnnotatorsRegistry annotatorsRegistry = new AnnotatorsRegistry();
        annotatorsRegistry.add(new GlobalBindingsAnnotator());
        annotatorsRegistry.add(new FunctionBindingsAnnotator());
        annotatorsRegistry.add(new MUnitDeclarationAnnotator());
        annotatorsRegistry.add(new TypeResolverAnnotator(this.typeResolverRegistry));
        annotatorsRegistry.add(new OperationCallAnnotator());
        annotatorsRegistry.add(new UnknownTypeResolverAnnotator());
        annotatorsRegistry.add(new TransformAnnotator());
        annotatorsRegistry.add(new MessageProcessorTypeDeclarationAnnotator());
        return annotatorsRegistry;
    }

    public void resolve() {
        AnnotatorsRegistry annotatorsRegistry = this.createAnnotatorsRegistry();
        if (logger.isDebugEnabled()) {
            logger.debug(StringUtils.repeat((String)"-", (int)10));
            AstUtils.dump(this.muleApplicationNode);
        }
        AstTyping astTyping = new AstTyping(annotatorsRegistry, this.typeResolverRegistry);
        if (logger.isDebugEnabled()) {
            logger.debug("== ANNOTATE " + StringUtils.repeat((String)"-", (int)10));
        }
        astTyping.annotate(this.muleApplicationNode, this.dataSenseProviderResolver, this.astNotification);
        if (logger.isDebugEnabled()) {
            logger.debug("== RESOLVE " + StringUtils.repeat((String)"-", (int)10));
        }
        EventType eventType = this.createInitialEvent();
        astTyping.resolveTypes(this.muleApplicationNode, eventType, this.astNotification, this.dataSenseProviderResolver.getExpressionLanguageMetadataService());
        if (logger.isDebugEnabled()) {
            logger.debug(StringUtils.repeat((String)"-", (int)10));
            AstUtils.dump(this.muleApplicationNode);
            logger.debug("== INCOMING " + StringUtils.repeat((String)"-", (int)10));
        }
        astTyping.generateIncoming(this.muleApplicationNode, eventType, this.astNotification, this.dataSenseProviderResolver.getExpressionLanguageMetadataService());
        if (logger.isDebugEnabled()) {
            logger.debug("== EXPECTED " + StringUtils.repeat((String)"-", (int)10));
        }
        astTyping.generateExpected(this.muleApplicationNode, eventType, this.astNotification, this.dataSenseProviderResolver.getExpressionLanguageMetadataService());
        if (logger.isDebugEnabled()) {
            logger.debug(StringUtils.repeat((String)"-", (int)10));
            AstUtils.dump(this.muleApplicationNode);
        }
    }

    public boolean resolveComponent(Location location) {
        return this.findMessageProcessorNode(location).flatMap(messageProcessorNode -> {
            AnnotatorsRegistry annotatorsRegistry = this.createAnnotatorsRegistry();
            String flowName = location.getGlobalName();
            return this.muleApplicationNode.findMuleFlowNode(flowName).map(muleFlowNode -> {
                AnnotatingMuleAstVisitor annotatingMuleAstVisitor = new AnnotatingMuleAstVisitor(annotatorsRegistry);
                AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext = new AnnotatingMuleAstVisitorContext(this.astNotification, this.dataSenseProviderResolver);
                annotatingMuleAstVisitorContext.annotate(new MuleFlowAnnotation((MuleFlowNode)muleFlowNode));
                annotatingMuleAstVisitor.annotate((AstNode)messageProcessorNode, annotatingMuleAstVisitorContext);
                return true;
            });
        }).orElse(false);
    }

    private EventType createInitialEvent() {
        return TypeUtils.createEventType(null);
    }

    public Optional<ComponentAst> find(Location location) {
        return this.findMessageProcessorNode(location).map(MessageProcessorNode::getComponentModel);
    }

    public Optional<MessageProcessorNode> findMessageProcessorNode(Location location) {
        return this.muleApplicationNode.findMessageProcessorNode(location);
    }

    public MuleApplicationNode getMuleApplicationNode() {
        return this.muleApplicationNode;
    }

    public DataSenseProviderResolver getDataSenseProviderResolver() {
        return this.dataSenseProviderResolver;
    }
}

