/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractHazelcastCacheManager;
import com.hazelcast.cache.impl.AbstractHazelcastCachingProvider;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.config.AbstractConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.config.YamlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import javax.annotation.Nonnull;

public final class HazelcastServerCachingProvider
extends AbstractHazelcastCachingProvider {
    public HazelcastServerCachingProvider() {
    }

    public HazelcastServerCachingProvider(HazelcastInstance instance) {
        this.hazelcastInstance = instance;
    }

    public String toString() {
        return "HazelcastServerCachingProvider{hazelcastInstance=" + this.hazelcastInstance + "}";
    }

    @Override
    protected <T extends AbstractHazelcastCacheManager> T createCacheManager(HazelcastInstance instance, URI uri, ClassLoader classLoader, Properties properties) {
        return (T)new HazelcastServerCacheManager(this, instance, uri, classLoader, properties);
    }

    @Override
    @Nonnull
    protected HazelcastInstance getOrCreateFromUri(@Nonnull URI uri, ClassLoader classLoader, String instanceName) throws URISyntaxException, IOException {
        Config config = this.getConfigFromLocation(uri, classLoader, instanceName);
        return HazelcastInstanceFactory.getOrCreateHazelcastInstance(config);
    }

    @Override
    @Nonnull
    protected HazelcastInstance getDefaultInstance() {
        if (this.hazelcastInstance == null) {
            Config config = this.getDefaultConfig();
            this.hazelcastInstance = StringUtil.isNullOrEmptyAfterTrim(config.getInstanceName()) ? Hazelcast.newHazelcastInstance() : Hazelcast.getOrCreateHazelcastInstance(config);
        }
        return this.hazelcastInstance;
    }

    @Override
    protected HazelcastInstance getOrCreateByInstanceName(String instanceName) {
        HazelcastInstance instance = Hazelcast.getHazelcastInstanceByName(instanceName);
        if (instance == null) {
            Config config = this.getDefaultConfig();
            config.setInstanceName(instanceName);
            instance = Hazelcast.getOrCreateHazelcastInstance(config);
        }
        return instance;
    }

    private Config getDefaultConfig() {
        Config config = new XmlConfigBuilder().build();
        if (this.namedDefaultHzInstance && StringUtil.isNullOrEmpty(config.getInstanceName())) {
            config.setInstanceName("_hzinstance_jcache_shared");
        }
        return config;
    }

    private Config getConfigFromLocation(URI location, ClassLoader classLoader, String instanceName) throws URISyntaxException, IOException {
        ClassLoader classLoaderOrDefault = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        URL configURL = this.getConfigURL(location, classLoaderOrDefault);
        try {
            return this.getConfig(configURL, classLoaderOrDefault, instanceName);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private Config getConfig(URL configURL, ClassLoader theClassLoader, String instanceName) throws IOException {
        AbstractConfigBuilder configBuilder = HazelcastServerCachingProvider.isYamlConfiguration(configURL) ? new YamlConfigBuilder(configURL) : new XmlConfigBuilder(configURL);
        Config config = configBuilder.build().setClassLoader(theClassLoader);
        if (instanceName != null) {
            config.setInstanceName(instanceName);
        } else if (config.getInstanceName() == null) {
            config.setInstanceName(configURL.toString());
        }
        return config;
    }
}

