/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.locksupport.LockSupportService;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.partition.impl.NameSpaceUtil;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.MapKeyLoaderUtil;
import com.hazelcast.map.impl.MapMigrationAwareService;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class PartitionContainerImpl
implements PartitionContainer {
    private final int partitionId;
    private final MapService mapService;
    private final ContextMutexFactory contextMutexFactory = new ContextMutexFactory();
    private final ConcurrentMap<String, RecordStore> maps;
    private final ConstructorFunction<String, RecordStore> recordStoreConstructor = name -> {
        RecordStore recordStore = this.createRecordStore((String)name);
        recordStore.startLoading();
        return recordStore;
    };
    private final ConstructorFunction<String, RecordStore> recordStoreConstructorSkipLoading = this::createRecordStore;
    private final ConstructorFunction<String, RecordStore> recordStoreConstructorForHotRestart = this::createRecordStore;
    private volatile boolean hasRunningCleanup;
    private volatile long lastCleanupTime;
    private long lastCleanupTimeCopy;

    public PartitionContainerImpl(MapService mapService, int partitionId) {
        this.mapService = mapService;
        this.partitionId = partitionId;
        int approxMapCount = mapService.mapServiceContext.getNodeEngine().getConfig().getMapConfigs().size();
        this.maps = MapUtil.createConcurrentHashMap(approxMapCount);
    }

    private RecordStore createRecordStore(String name) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapContainer mapContainer = mapServiceContext.getMapContainer(name);
        MapKeyLoader keyLoader = mapContainer.getMapStoreContext().isMapLoader() ? this.createMapKeyLoader(mapServiceContext, mapContainer) : null;
        int partitionId = this.getPartitionId();
        if (!mapContainer.shouldUseGlobalIndex()) {
            mapContainer.createIndexRegistry(false, partitionId);
        }
        RecordStore recordStore = mapServiceContext.createRecordStore(mapContainer, partitionId, keyLoader);
        recordStore.init();
        return recordStore;
    }

    private MapKeyLoader createMapKeyLoader(MapServiceContext mapServiceContext, MapContainer mapContainer) {
        MapConfig mapConfig = mapContainer.getMapConfig();
        String mapName = mapContainer.getName();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        IPartitionService partitionService = nodeEngine.getPartitionService();
        ExecutionService executionService = nodeEngine.getExecutionService();
        OperationService opService = nodeEngine.getOperationService();
        MapKeyLoader keyLoader = new MapKeyLoader(mapName, opService, partitionService, nodeEngine.getClusterService(), executionService, mapContainer.toData(), mapServiceContext.getNodeWideLoadedKeyLimiter());
        keyLoader.setMaxBatch(nodeEngine.getProperties().getInteger(ClusterProperty.MAP_LOAD_CHUNK_SIZE));
        keyLoader.setMaxSize(MapKeyLoaderUtil.getMaxSizePerNode(mapConfig.getEvictionConfig()));
        keyLoader.setHasBackup(mapConfig.getTotalBackupCount() > 0);
        keyLoader.setMapOperationProvider(mapServiceContext.getMapOperationProvider(mapName));
        return keyLoader;
    }

    @Override
    public ConcurrentMap<String, RecordStore> getMaps() {
        return this.maps;
    }

    @Override
    public Collection<RecordStore> getAllRecordStores() {
        return this.maps.isEmpty() ? Collections.emptyList() : this.maps.values();
    }

    @Override
    public Collection<ServiceNamespace> getAllNamespaces(int replicaIndex) {
        return this.getNamespaces(ignored -> true, replicaIndex);
    }

    @Override
    public Collection<ServiceNamespace> getNamespaces(Predicate<MapConfig> predicate, int replicaIndex) {
        return NameSpaceUtil.getAllNamespaces(this.maps, recordStore -> {
            MapContainer mapContainer = recordStore.getMapContainer();
            MapConfig mapConfig = mapContainer.getMapConfig();
            return mapConfig.getTotalBackupCount() >= replicaIndex && predicate.test(mapConfig);
        }, recordStore -> recordStore.getMapContainer().getObjectNamespace());
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public MapService getMapService() {
        return this.mapService;
    }

    @Override
    public RecordStore getRecordStore(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.maps, name, this.contextMutexFactory, this.recordStoreConstructor);
    }

    @Override
    public RecordStore getRecordStore(String name, boolean skipLoadingOnCreate) {
        return ConcurrencyUtil.getOrPutSynchronized(this.maps, name, this, skipLoadingOnCreate ? this.recordStoreConstructorSkipLoading : this.recordStoreConstructor);
    }

    @Override
    public RecordStore getRecordStoreForHotRestart(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.maps, name, this.contextMutexFactory, this.recordStoreConstructorForHotRestart);
    }

    @Override
    @Nullable
    public RecordStore getExistingRecordStore(String mapName) {
        return (RecordStore)this.maps.get(mapName);
    }

    @Override
    public final void destroyMap(MapContainer mapContainer) {
        mapContainer.onBeforeDestroy();
        String name = mapContainer.getName();
        RecordStore recordStore = (RecordStore)this.maps.remove(name);
        if (recordStore != null) {
            recordStore.destroy();
        } else {
            this.clearLockStore(name);
        }
        MapServiceContext mapServiceContext = this.mapService.mapServiceContext;
        mapServiceContext.removeMapContainer(mapContainer);
        mapServiceContext.removePartitioningStrategyFromCache(mapContainer.getName());
    }

    private void clearLockStore(String name) {
        NodeEngine nodeEngine = this.mapService.getMapServiceContext().getNodeEngine();
        LockSupportService lockService = (LockSupportService)nodeEngine.getServiceOrNull("hz:impl:lockService");
        if (lockService != null) {
            ObjectNamespace namespace = MapService.getObjectNamespace(name);
            lockService.clearLockStore(this.partitionId, namespace);
        }
    }

    @Override
    public boolean hasRunningCleanup() {
        return this.hasRunningCleanup;
    }

    @Override
    public void setHasRunningCleanup(boolean hasRunningCleanup) {
        this.hasRunningCleanup = hasRunningCleanup;
    }

    @Override
    public long getLastCleanupTime() {
        return this.lastCleanupTime;
    }

    @Override
    public void setLastCleanupTime(long lastCleanupTime) {
        this.lastCleanupTime = lastCleanupTime;
    }

    @Override
    public long getLastCleanupTimeCopy() {
        return this.lastCleanupTimeCopy;
    }

    @Override
    public void setLastCleanupTimeCopy(long lastCleanupTimeCopy) {
        this.lastCleanupTimeCopy = lastCleanupTimeCopy;
    }

    @Override
    public final void cleanUpOnMigration(int replicaIndex) {
        this.mapService.getMapServiceContext().getMapContainers().entrySet().stream().filter(entry -> replicaIndex == -1 || MapMigrationAwareService.lesserBackupMapsThenWithContainer(replicaIndex).test((MapContainer)entry.getValue())).forEach(entry -> this.cleanUpMap((String)entry.getKey(), (MapContainer)entry.getValue()));
    }

    protected void cleanUpMap(String mapName, MapContainer mapContainer) {
    }
}

