/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.core.LocalMemberResetException;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.ClusterClock;
import com.hazelcast.internal.diagnostics.OperationProfilerPlugin;
import com.hazelcast.internal.management.dto.SlowOperationDTO;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.StaticMetricsProvider;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.LatencyDistribution;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationexecutor.impl.OperationExecutorImpl;
import com.hazelcast.spi.impl.operationexecutor.slowoperationdetector.SlowOperationDetector;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.LiveOperations;
import com.hazelcast.spi.impl.operationservice.LiveOperationsTracker;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.Operations;
import com.hazelcast.spi.impl.operationservice.PartitionTaskFactory;
import com.hazelcast.spi.impl.operationservice.impl.BackpressureRegulator;
import com.hazelcast.spi.impl.operationservice.impl.InboundResponseHandler;
import com.hazelcast.spi.impl.operationservice.impl.InboundResponseHandlerSupplier;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationBuilderImpl;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.InvocationMonitor;
import com.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.hazelcast.spi.impl.operationservice.impl.InvokeOnPartitions;
import com.hazelcast.spi.impl.operationservice.impl.MasterInvocation;
import com.hazelcast.spi.impl.operationservice.impl.OperationBackupHandler;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerFactoryImpl;
import com.hazelcast.spi.impl.operationservice.impl.OutboundOperationHandler;
import com.hazelcast.spi.impl.operationservice.impl.OutboundResponseHandler;
import com.hazelcast.spi.impl.operationservice.impl.PartitionInvocation;
import com.hazelcast.spi.impl.operationservice.impl.TargetInvocation;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public final class OperationServiceImpl
implements StaticMetricsProvider,
LiveOperationsTracker,
OperationService {
    private static final long TERMINATION_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    @Probe(name="asyncOperations")
    final Set<Operation> asyncOperations = Collections.newSetFromMap(new ConcurrentHashMap());
    final ConcurrentMap<Class, LatencyDistribution> opLatencyDistributions;
    final InvocationRegistry invocationRegistry;
    final OperationExecutor operationExecutor;
    @Probe(name="operationTimeoutCount", level=ProbeLevel.MANDATORY)
    final MwCounter operationTimeoutCount = MwCounter.newMwCounter();
    @Probe(name="callTimeoutCount", level=ProbeLevel.MANDATORY)
    final MwCounter callTimeoutCount = MwCounter.newMwCounter();
    @Probe(name="retryCount", level=ProbeLevel.MANDATORY)
    final MwCounter retryCount = MwCounter.newMwCounter();
    @Probe(name="failedBackups", level=ProbeLevel.MANDATORY)
    final Counter failedBackupsCount = MwCounter.newMwCounter();
    final NodeEngineImpl nodeEngine;
    final Node node;
    final ILogger logger;
    final OperationBackupHandler backupHandler;
    final BackpressureRegulator backpressureRegulator;
    final OutboundResponseHandler outboundResponseHandler;
    final OutboundOperationHandler outboundOperationHandler;
    volatile Invocation.Context invocationContext;
    private final InvocationMonitor invocationMonitor;
    private final SlowOperationDetector slowOperationDetector;
    private final InboundResponseHandlerSupplier inboundResponseHandlerSupplier;
    private final InternalSerializationService serializationService;
    private final int invocationMaxRetryCount;
    private final long invocationRetryPauseMillis;
    private final boolean failOnIndeterminateOperationState;

    public OperationServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.node = nodeEngine.getNode();
        Address thisAddress = this.node.getThisAddress();
        this.logger = this.node.getLogger(OperationService.class);
        this.serializationService = (InternalSerializationService)nodeEngine.getSerializationService();
        this.opLatencyDistributions = nodeEngine.getProperties().getInteger(OperationProfilerPlugin.PERIOD_SECONDS) > 0 ? new ConcurrentHashMap() : null;
        HazelcastProperties properties = this.node.getProperties();
        this.invocationMaxRetryCount = properties.getInteger(ClusterProperty.INVOCATION_MAX_RETRY_COUNT);
        this.invocationRetryPauseMillis = properties.getMillis(ClusterProperty.INVOCATION_RETRY_PAUSE);
        this.failOnIndeterminateOperationState = nodeEngine.getProperties().getBoolean(ClusterProperty.FAIL_ON_INDETERMINATE_OPERATION_STATE);
        this.backpressureRegulator = new BackpressureRegulator(properties, this.node.getLogger(BackpressureRegulator.class));
        this.outboundResponseHandler = new OutboundResponseHandler(thisAddress, this.serializationService, this.node.getLogger(OutboundResponseHandler.class));
        this.invocationRegistry = new InvocationRegistry(this.node.getLogger(OperationServiceImpl.class), this.backpressureRegulator.newCallIdSequence(nodeEngine.getConcurrencyDetection()), properties);
        this.invocationMonitor = new InvocationMonitor(nodeEngine, thisAddress, properties, this.invocationRegistry, this.node.getLogger(InvocationMonitor.class), this.serializationService, nodeEngine.getServiceManager());
        this.outboundOperationHandler = new OutboundOperationHandler(this.node, this.serializationService);
        this.backupHandler = new OperationBackupHandler(this, this.outboundOperationHandler);
        String hzName = nodeEngine.getHazelcastInstance().getName();
        ClassLoader configClassLoader = this.node.getConfigClassLoader();
        this.inboundResponseHandlerSupplier = new InboundResponseHandlerSupplier(configClassLoader, this.invocationRegistry, hzName, nodeEngine);
        this.operationExecutor = new OperationExecutorImpl(properties, this.node.loggingService, thisAddress, new OperationRunnerFactoryImpl(this), nodeEngine, this.node.getNodeExtension(), hzName, configClassLoader, nodeEngine.getTpcServerBootstrap());
        this.slowOperationDetector = new SlowOperationDetector(this.node.loggingService, this.operationExecutor.getGenericOperationRunners(), this.operationExecutor.getPartitionOperationRunners(), properties, hzName);
    }

    public Set<Operation> getAsyncOperations() {
        return this.asyncOperations;
    }

    public ConcurrentMap<Class, LatencyDistribution> getOpLatencyDistributions() {
        return this.opLatencyDistributions;
    }

    public OutboundResponseHandler getOutboundResponseHandler() {
        return this.outboundResponseHandler;
    }

    public InboundResponseHandlerSupplier getInboundResponseHandlerSupplier() {
        return this.inboundResponseHandlerSupplier;
    }

    public InvocationMonitor getInvocationMonitor() {
        return this.invocationMonitor;
    }

    @Override
    public List<SlowOperationDTO> getSlowOperationDTOs() {
        return this.slowOperationDetector.getSlowOperationDTOs();
    }

    public InvocationRegistry getInvocationRegistry() {
        return this.invocationRegistry;
    }

    public InboundResponseHandler getBackupHandler() {
        return this.inboundResponseHandlerSupplier.backupHandler();
    }

    @Override
    public int getPartitionThreadCount() {
        return this.operationExecutor.getPartitionThreadCount();
    }

    @Override
    public int getGenericThreadCount() {
        return this.operationExecutor.getGenericThreadCount();
    }

    @Override
    public int getRunningOperationsCount() {
        return this.operationExecutor.getRunningOperationCount();
    }

    @Override
    public long getExecutedOperationCount() {
        return this.operationExecutor.getExecutedOperationCount();
    }

    @Override
    public int getRemoteOperationsCount() {
        return this.invocationRegistry.size();
    }

    @Override
    public int getOperationExecutorQueueSize() {
        return this.operationExecutor.getQueueSize();
    }

    @Override
    public int getPriorityOperationExecutorQueueSize() {
        return this.operationExecutor.getPriorityQueueSize();
    }

    public OperationExecutor getOperationExecutor() {
        return this.operationExecutor;
    }

    @Override
    public int getResponseQueueSize() {
        return this.inboundResponseHandlerSupplier.responseQueueSize();
    }

    @Override
    public void populate(LiveOperations liveOperations) {
        this.operationExecutor.populate(liveOperations);
        for (Operation op : this.asyncOperations) {
            liveOperations.add(op.getCallerAddress(), op.getCallId());
        }
    }

    @Override
    public void execute(PartitionSpecificRunnable task) {
        this.operationExecutor.execute(task);
    }

    @Override
    public void executeOnPartitions(PartitionTaskFactory taskFactory, BitSet partitions) {
        this.operationExecutor.executeOnPartitions(taskFactory, partitions);
    }

    @Override
    public InvocationBuilder createInvocationBuilder(String serviceName, Operation op, int partitionId) {
        Preconditions.checkNotNegative(partitionId, "Partition ID cannot be negative!");
        return InvocationBuilderImpl.createForPartition(this.invocationContext, serviceName, op, partitionId).setTryCount(this.invocationMaxRetryCount).setTryPauseMillis(this.invocationRetryPauseMillis).setFailOnIndeterminateOperationState(this.failOnIndeterminateOperationState);
    }

    @Override
    public InvocationBuilder createInvocationBuilder(String serviceName, Operation op, Address target) {
        Preconditions.checkNotNull(target, "Target cannot be null!");
        return InvocationBuilderImpl.createForTarget(this.invocationContext, serviceName, op, target).setTryCount(this.invocationMaxRetryCount).setTryPauseMillis(this.invocationRetryPauseMillis);
    }

    @Override
    public InvocationBuilder createMasterInvocationBuilder(String serviceName, Operation op) {
        return InvocationBuilderImpl.createForMaster(this.invocationContext, serviceName, op).setTryCount(this.invocationMaxRetryCount).setTryPauseMillis(this.invocationRetryPauseMillis);
    }

    @Override
    public void run(Operation op) {
        this.operationExecutor.run(op);
    }

    @Override
    public void execute(Operation op) {
        this.operationExecutor.execute(op);
    }

    @Override
    public boolean isRunAllowed(Operation op) {
        return this.operationExecutor.isRunAllowed(op);
    }

    @Override
    public <E> InvocationFuture<E> invokeOnPartition(String serviceName, Operation op, int partitionId) {
        op.setServiceName(serviceName).setPartitionId(partitionId).setReplicaIndex(0);
        return new PartitionInvocation(this.invocationContext, op, this.invocationMaxRetryCount, this.invocationRetryPauseMillis, -1L, true, this.failOnIndeterminateOperationState).invoke();
    }

    @Override
    public <E> InvocationFuture<E> invokeOnPartitionAsync(String serviceName, Operation op, int partitionId) {
        return this.invokeOnPartitionAsync(serviceName, op, partitionId, 0);
    }

    @Override
    public <E> InvocationFuture<E> invokeOnPartitionAsync(String serviceName, Operation op, int partitionId, int replicaIndex) {
        op.setServiceName(serviceName).setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        return new PartitionInvocation(this.invocationContext, op, this.invocationMaxRetryCount, this.invocationRetryPauseMillis, -1L, true, this.failOnIndeterminateOperationState).invokeAsync();
    }

    @Override
    public <E> InvocationFuture<E> invokeOnPartition(Operation op) {
        return new PartitionInvocation(this.invocationContext, op, this.invocationMaxRetryCount, this.invocationRetryPauseMillis, -1L, true, this.failOnIndeterminateOperationState).invoke();
    }

    @Override
    public <E> InvocationFuture<E> invokeOnTarget(String serviceName, Operation op, Address target) {
        op.setServiceName(serviceName);
        return new TargetInvocation(this.invocationContext, op, target, this.invocationMaxRetryCount, this.invocationRetryPauseMillis, -1L, true).invoke();
    }

    @Override
    public <E> InvocationFuture<E> invokeOnTargetAsync(String serviceName, Operation op, Address target) {
        op.setServiceName(serviceName);
        return new TargetInvocation(this.invocationContext, op, target, this.invocationMaxRetryCount, this.invocationRetryPauseMillis, -1L, true).invokeAsync();
    }

    @Override
    public <E> InvocationFuture<E> invokeOnMaster(String serviceName, Operation op) {
        op.setServiceName(serviceName);
        return new MasterInvocation(this.invocationContext, op, this.invocationMaxRetryCount, this.invocationRetryPauseMillis, -1L, true).invoke();
    }

    @Override
    public void onStartAsyncOperation(Operation op) {
        this.asyncOperations.add(op);
    }

    @Override
    public void onCompletionAsyncOperation(Operation op) {
        this.asyncOperations.remove(op);
    }

    @Override
    public boolean isCallTimedOut(Operation op) {
        if (Operations.isJoinOperation(op) || Operations.isWanReplicationOperation(op)) {
            return false;
        }
        long callTimeout = op.getCallTimeout();
        long invocationTime = op.getInvocationTime();
        long expireTime = invocationTime + callTimeout;
        if (expireTime <= 0L || expireTime == Long.MAX_VALUE) {
            return false;
        }
        ClusterClock clusterClock = this.nodeEngine.getClusterService().getClusterClock();
        long now = clusterClock.getClusterTime();
        return expireTime < now;
    }

    @Override
    public Map<Integer, Object> invokeOnAllPartitions(String serviceName, OperationFactory operationFactory) throws Exception {
        Map<Address, List<Integer>> memberPartitions = this.nodeEngine.getPartitionService().getMemberPartitionsMap();
        InvokeOnPartitions invokeOnPartitions = new InvokeOnPartitions(this, serviceName, operationFactory, memberPartitions);
        return invokeOnPartitions.invoke();
    }

    @Override
    public <T> CompletableFuture<Map<Integer, T>> invokeOnAllPartitionsAsync(String serviceName, OperationFactory operationFactory) {
        Map<Address, List<Integer>> memberPartitions = this.nodeEngine.getPartitionService().getMemberPartitionsMap();
        InvokeOnPartitions invokeOnPartitions = new InvokeOnPartitions(this, serviceName, operationFactory, memberPartitions);
        return invokeOnPartitions.invokeAsync();
    }

    @Override
    public <T> Map<Integer, T> invokeOnPartitions(String serviceName, OperationFactory operationFactory, Collection<Integer> partitions) throws Exception {
        Map<Address, List<Integer>> memberPartitions = this.getMemberPartitions(partitions);
        InvokeOnPartitions invokeOnPartitions = new InvokeOnPartitions(this, serviceName, operationFactory, memberPartitions);
        return invokeOnPartitions.invoke();
    }

    private Map<Address, List<Integer>> getMemberPartitions(Collection<Integer> partitions) {
        Map<Address, List<Integer>> memberPartitions = MapUtil.createHashMap(3);
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        for (int partition : partitions) {
            Address owner = partitionService.getPartitionOwnerOrWait(partition);
            memberPartitions.computeIfAbsent(owner, k -> new ArrayList()).add(partition);
        }
        return memberPartitions;
    }

    @Override
    public <T> CompletableFuture<Map<Integer, T>> invokeOnPartitionsAsync(String serviceName, OperationFactory operationFactory, Collection<Integer> partitions) {
        return this.invokeOnPartitionsAsync(serviceName, operationFactory, this.getMemberPartitions(partitions));
    }

    @Override
    public <T> CompletableFuture<Map<Integer, T>> invokeOnPartitionsAsync(String serviceName, OperationFactory operationFactory, Map<Address, List<Integer>> memberPartitions) {
        InvokeOnPartitions invokeOnPartitions = new InvokeOnPartitions(this, serviceName, operationFactory, memberPartitions);
        return invokeOnPartitions.invokeAsync();
    }

    @Override
    public Map<Integer, Object> invokeOnPartitions(String serviceName, OperationFactory operationFactory, int[] partitions) throws Exception {
        return this.invokeOnPartitions(serviceName, operationFactory, CollectionUtil.asIntegerList(partitions));
    }

    @Override
    public boolean send(Operation op, Address target) {
        return this.outboundOperationHandler.send(op, target);
    }

    public void onMemberLeft(MemberImpl member) {
        this.invocationMonitor.onMemberLeft(member);
    }

    @Override
    public void onEndpointLeft(Address endpoint) {
        this.invocationMonitor.onEndpointLeft(endpoint);
    }

    public void reset() {
        LocalMemberResetException cause = new LocalMemberResetException(this.node.getLocalMember() + " has reset.");
        this.invocationRegistry.reset(cause);
    }

    @Override
    public void provideStaticMetrics(MetricsRegistry registry) {
        registry.registerStaticMetrics(this, "operation");
        registry.provideMetrics(this.invocationRegistry, this.invocationMonitor, this.inboundResponseHandlerSupplier, this.operationExecutor);
    }

    public void start() {
        this.logger.finest("Starting OperationService");
        this.initInvocationContext();
        this.invocationMonitor.start();
        this.operationExecutor.start();
        this.inboundResponseHandlerSupplier.start();
        this.slowOperationDetector.start();
    }

    private void initInvocationContext() {
        this.invocationContext = new Invocation.Context(this.nodeEngine.getExecutionService().getExecutor("hz:async"), this.nodeEngine.getClusterService().getClusterClock(), this.nodeEngine.getClusterService(), this.node.getServer(), this.node.nodeEngine.getExecutionService(), this.nodeEngine.getProperties().getMillis(ClusterProperty.OPERATION_CALL_TIMEOUT_MILLIS), this.invocationRegistry, this.invocationMonitor, this.nodeEngine.getLogger(Invocation.class), this.node, this.nodeEngine, this.nodeEngine.getPartitionService(), this, this.operationExecutor, this.retryCount, this.serializationService, this.nodeEngine.getThisAddress(), this.outboundOperationHandler, this.node.getServer().getConnectionManager(EndpointQualifier.MEMBER));
    }

    public Invocation.Context getInvocationContext() {
        return this.invocationContext;
    }

    public void shutdownInvocations() {
        this.logger.finest("Shutting down invocations");
        this.invocationRegistry.shutdown();
        this.invocationMonitor.shutdown();
        this.inboundResponseHandlerSupplier.shutdown();
        try {
            this.invocationMonitor.awaitTermination(TERMINATION_TIMEOUT_MILLIS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void shutdownOperationExecutor() {
        this.logger.finest("Shutting down operation executors");
        this.operationExecutor.shutdown();
        this.slowOperationDetector.shutdown();
    }
}

