/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.impl;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.topic.impl.TopicDataSerializerHook;
import com.hazelcast.topic.impl.TopicEvent;
import com.hazelcast.topic.impl.TopicService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.locks.Lock;

public class PublishAllOperation
extends AbstractNamedOperation
implements IdentifiedDataSerializable {
    private Data[] messages;

    public PublishAllOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public PublishAllOperation(String name, Data[] messages) {
        super(name);
        this.messages = messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        TopicService service = (TopicService)this.getService();
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:topicService", this.name);
        Lock lock = service.getOrderLock(this.name);
        lock.lock();
        try {
            for (Data item : this.messages) {
                TopicEvent topicEvent = new TopicEvent(this.name, item, this.getCallerAddress());
                eventService.publishEvent("hz:impl:topicService", registrations, (Object)topicEvent, this.name.hashCode());
                service.incrementPublishes(this.name);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getFactoryId() {
        return TopicDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:topicService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.messages.length);
        for (Data item : this.messages) {
            IOUtil.writeData(out, item);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int length = in.readInt();
        this.messages = new Data[length];
        for (int k = 0; k < this.messages.length; ++k) {
            this.messages[k] = IOUtil.readData(in);
        }
    }
}

