/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.reboot;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManagementFactory;
import com.mulesoft.licm.impl.MuleLicenseInterrupter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.mule.runtime.module.reboot.internal.EEMuleContainerWrapper;
import org.mule.runtime.module.reboot.internal.FipsSecurityManager;
import org.mule.runtime.module.reboot.internal.LicenseKeyHandler;
import org.mule.runtime.module.reboot.internal.MuleContainerWrapper;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;

public class MuleContainerBootstrap {
    private static final String MULE_MODULE_BOOT_POM_FILE_PATH = "META-INF/maven/org.mule.module/mule-module-boot/pom.properties";
    private static CompletableFuture<EnterpriseLicenseKey> LICENSE_VALIDATION = new CompletableFuture();
    public static final String TESTING_MODE_PROPERTY_NAME = "mule.testingMode";
    public static final String[][] CLI_OPTIONS = new String[][]{{"main", "true", "Main Class"}, {"installLicense", "true", "Replace current license with new license supplied"}, {"unInstallLicense", "false", "Uninstall current license"}, {"verifyLicense", "false", "Prints currently installed license details"}, {"version", "false", "Show product and version information"}};
    public static boolean eval;
    public static boolean testingMode;

    public static void main(String[] args) throws Exception {
        Integer requestedExitCode;
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        String[] remainingArgs = null;
        String errorMessage = null;
        try {
            CommandLine commandLine = MuleContainerBootstrap.parseCommandLine(args);
            remainingArgs = commandLine.getArgs();
            requestedExitCode = MuleContainerBootstrap.handleLicenseKey(commandLine);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            requestedExitCode = 1;
            errorMessage = ex.getMessage();
        }
        try {
            FipsSecurityManager fipsSecurityManager = new FipsSecurityManager();
            if (fipsSecurityManager.isFipsEnabled()) {
                fipsSecurityManager.configureFips();
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            requestedExitCode = 2;
            errorMessage = ex.getMessage();
        }
        if (requestedExitCode != null) {
            WrapperManager.start((WrapperListener)new WrapperListener(){

                public Integer start(String[] args) {
                    return null;
                }

                public int stop(int exitCode) {
                    return exitCode;
                }

                public void controlEvent(int event) {
                }
            }, (String[])new String[0]);
            MuleContainerBootstrap.haltAndCatchFire(requestedExitCode, errorMessage);
        } else {
            MuleContainerBootstrap.prepareBootstrapPhase();
            System.out.println("Starting the Mule Container...");
            WrapperManager.start((WrapperListener)new EEMuleContainerWrapper(), (String[])remainingArgs);
        }
    }

    private static void haltAndCatchFire(Integer requestedExitCode, final String message) {
        WrapperManager.addWrapperEventListener((WrapperEventListener)new WrapperEventListener(){
            private boolean errorAlreadyLogged = false;

            public void fired(WrapperEvent event) {
                if (!this.errorAlreadyLogged && message != null) {
                    WrapperManager.log((int)5, (String)message);
                    this.errorAlreadyLogged = true;
                }
            }
        }, (long)4L);
        WrapperManager.stop((int)requestedExitCode);
    }

    private static void validateLicense(Supplier<LicenseKeyHandler> licenseKeyHandler) {
        new Thread(() -> MuleContainerBootstrap.doValidateLicense(licenseKeyHandler)).start();
    }

    private static void doValidateLicense(Supplier<LicenseKeyHandler> licenseKeyHandler) {
        try {
            EnterpriseLicenseKey key = licenseKeyHandler.get().validate();
            if (key != null) {
                if (MuleContainerBootstrap.isTestingMode()) {
                    MuleContainerBootstrap.setKey(key, true);
                    System.out.println();
                    System.out.println("Running Mule in testing mode");
                    System.out.println();
                    LICENSE_VALIDATION.complete(key);
                } else {
                    MuleContainerBootstrap.setKey(key, false);
                    System.out.println();
                    System.out.println("Valid license key --> " + key);
                    System.out.println();
                }
                LICENSE_VALIDATION.complete(key);
            } else {
                LICENSE_VALIDATION.completeExceptionally(new LicenseKeyException());
            }
        }
        catch (Exception e) {
            LICENSE_VALIDATION.completeExceptionally(e);
        }
    }

    public static void awaitLicenseValidation() {
        if (MuleContainerBootstrap.isTestingMode()) {
            return;
        }
        try {
            LICENSE_VALIDATION.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof LicenseKeyException) {
                MuleContainerBootstrap.printInvalidLicenseMessage();
                MuleContainerBootstrap.haltAndCatchFire(1, "");
            } else {
                MuleContainerBootstrap.haltAndCatchFire(1, e.getMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void printInvalidLicenseMessage() {
        System.out.println("Invalid license key, stopping now");
    }

    private static void setKey(EnterpriseLicenseKey key, boolean _testingMode) {
        eval = key.isEvaluation();
        testingMode = _testingMode;
    }

    private static boolean isTestingMode() {
        return System.getProperty(TESTING_MODE_PROPERTY_NAME) != null;
    }

    private static void prepareBootstrapPhase() throws Exception {
        MuleContainerBootstrap.setSystemMuleVersion();
    }

    public static File lookupMuleHome() throws Exception {
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals("%MULE_HOME%")) {
            muleHome = new File(muleHomeVar).getCanonicalFile();
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either the system property mule.home is not set or does not contain a valid directory.");
        }
        return muleHome;
    }

    public static File lookupMuleBase() throws Exception {
        File muleBase = null;
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            muleBase = new File(muleBaseVar).getCanonicalFile();
        }
        return muleBase;
    }

    public static boolean isBypassLicenseCheck() {
        return eval || testingMode;
    }

    public static long getWrapperPID() {
        return WrapperManager.getWrapperPID();
    }

    public static long getJavaPID() {
        return WrapperManager.getJavaPID();
    }

    private static void setSystemMuleVersion() {
        block14: {
            InputStream propertiesStream = null;
            try {
                try {
                    URL mavenPropertiesUrl = MuleContainerBootstrapUtils.getResource(MULE_MODULE_BOOT_POM_FILE_PATH, MuleContainerWrapper.class);
                    propertiesStream = mavenPropertiesUrl.openStream();
                    Properties mavenProperties = new Properties();
                    mavenProperties.load(propertiesStream);
                    System.setProperty("mule.version", mavenProperties.getProperty("version"));
                    System.setProperty("mule.reference.version", String.valueOf(mavenProperties.getProperty("version")) + '-' + new Date().getTime());
                }
                catch (Exception exception) {
                    if (propertiesStream != null) {
                        try {
                            propertiesStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (propertiesStream != null) {
                    try {
                        propertiesStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (propertiesStream != null) {
                try {
                    propertiesStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        String[][] stringArray = CLI_OPTIONS;
        int n = CLI_OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            options.addOption(element[0], "true".equalsIgnoreCase(element[1]), element[2]);
            ++n2;
        }
        return new BasicParser().parse(options, args, true);
    }

    private static Integer handleLicenseKey(CommandLine commandLine) throws Exception {
        LazySupplier<Supplier<LicenseKeyHandler>> licenseKeyHandler = new LazySupplier<Supplier<LicenseKeyHandler>>(LicenseKeyHandler::new);
        LazySupplier<EnterpriseLicenseKey> key = new LazySupplier<EnterpriseLicenseKey>(LicenseManagementFactory.getInstance().createLicenseKey("mule-ee"));
        if (commandLine.hasOption("installLicense")) {
            String keyRequestFile = commandLine.getOptionValue("installLicense");
            File keyRequest = new File(keyRequestFile);
            if (!keyRequest.exists()) {
                throw new IOException("License key file - " + keyRequestFile + " not found!");
            }
            key.get().setLicenseKeyFile(keyRequestFile);
            EnterpriseLicenseKey newKey = ((LicenseKeyHandler)((Object)licenseKeyHandler.get())).install(key.get());
            System.out.println();
            System.out.println("Installed license key.");
            System.out.println(newKey);
            System.out.println();
            return 0;
        }
        if (commandLine.hasOption("unInstallLicense")) {
            ((LicenseKeyHandler)((Object)licenseKeyHandler.get())).unInstall();
            System.out.println();
            System.out.println("Uninstalled license key.");
            System.out.println();
            return 0;
        }
        if (commandLine.hasOption("verifyLicense")) {
            key = new LazySupplier<EnterpriseLicenseKey>(((LicenseKeyHandler)((Object)licenseKeyHandler.get())).validate());
            if (key != null) {
                System.out.println();
                System.out.println("Valid license key --> " + key.get());
                System.out.println();
                return 0;
            }
            return 1;
        }
        MuleContainerBootstrap.validateLicense(licenseKeyHandler);
        return null;
    }

    public static void dispose() {
        MuleLicenseInterrupter.dispose();
    }

    private static class LazySupplier<T>
    implements Supplier<T> {
        private volatile boolean initialized = false;
        private T value;
        private Supplier<T> valueSupplier;

        public LazySupplier(Supplier<T> supplier) {
            this.valueSupplier = supplier;
        }

        public LazySupplier(T value) {
            this.value = value;
            this.initialized = true;
            this.valueSupplier = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                LazySupplier lazySupplier = this;
                synchronized (lazySupplier) {
                    if (!this.initialized) {
                        this.value = this.valueSupplier.get();
                        this.valueSupplier = null;
                        this.initialized = true;
                    }
                }
            }
            return this.value;
        }
    }
}

