/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.reboot.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.mule.runtime.module.reboot.internal.DefaultMuleClassPathConfig;
import org.mule.runtime.module.reboot.internal.PatchScanner;

public class EEMuleClassPathConfig
extends DefaultMuleClassPathConfig {
    protected static String PATCHES_DIR = "lib/patches";

    public EEMuleClassPathConfig(File muleHome, File muleBase) {
        super(muleHome, muleBase);
    }

    @Override
    protected void init(File muleHome, File muleBase) {
        this.addPatches(muleHome, muleBase);
        super.init(muleHome, muleBase);
    }

    protected void addPatches(File muleHome, File muleBase) {
        try {
            File base = this.determineBaseDirectory(muleHome, muleBase);
            File patchDirectory = new File(base, PATCHES_DIR);
            if (patchDirectory.exists()) {
                this.addPatchJars(patchDirectory);
            }
        }
        catch (IOException iox) {
            System.out.println("Unable to add patches: " + iox.toString());
        }
    }

    private File determineBaseDirectory(File muleHome, File muleBase) throws IOException {
        File baseCanonical;
        File homeCanonical = muleHome.getCanonicalFile();
        return homeCanonical.equals(baseCanonical = muleBase.getCanonicalFile()) ? homeCanonical : baseCanonical;
    }

    protected void addPatchJars(File patchDirectory) {
        PatchScanner scanner = new PatchScanner(patchDirectory);
        List<File> patchJars = scanner.listPatchJars();
        this.addFiles(patchJars);
    }
}

