/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.internal.locator.ComponentLocator;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.api.value.ValueResult;
import org.mule.tooling.client.api.value.provider.ValueProviderDisposeRequest;
import org.mule.tooling.client.api.value.provider.ValueProviderRequest;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.action.DispacheableAction;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.utils.ValueUtils;
import org.mule.tooling.client.internal.values.ValueProviderCache;

public abstract class AbstractValueProviderService
implements ValueProviderService,
Command {
    private LazyValue<ValueProviderCache> valueProviderCache;
    private LazyValue<? extends ComponentLocator<ComponentAst>> locator;
    private Serializer serializer;
    private Supplier<List<ExtensionModel>> extensionModelsSupplier;

    protected AbstractValueProviderService(Supplier<List<ExtensionModel>> extensionModelsSupplier, Serializer serializer, LazyValue<ValueProviderCache> valueProviderCache, LazyValue<? extends ComponentLocator<ComponentAst>> locator) {
        Objects.requireNonNull(extensionModelsSupplier, "extensionModelsSupplier should not be null");
        Objects.requireNonNull(serializer, "serializer cannot be null");
        Objects.requireNonNull(valueProviderCache, "value providers cache cannot be null");
        Objects.requireNonNull(locator, "component locator should not be null");
        this.serializer = serializer;
        this.valueProviderCache = valueProviderCache;
        this.locator = locator;
        this.extensionModelsSupplier = extensionModelsSupplier;
    }

    private List<ExtensionModel> getExtensionModels() {
        return this.extensionModelsSupplier.get();
    }

    public ValueResult getValues(ValueProviderRequest valueProviderRequest) {
        try {
            return ValueUtils.toValueResultDTO(((ComponentLocator)this.locator.get()).get(Location.builderFromStringRepresentation((String)valueProviderRequest.getLocation()).build()).map(componentAst -> this.cloneAndEnrichValues(((ValueProviderCache)this.valueProviderCache.get()).getValues((ComponentAst)componentAst, valueProviderRequest.getProviderName(), () -> this.doGetValue(valueProviderRequest)), (ComponentAst)componentAst, valueProviderRequest.getProviderName())).orElse(org.mule.runtime.api.value.ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure().withMessage("Could not find component with location: " + valueProviderRequest.getLocation() + " for resolving values").withFailureCode("INVALID_LOCATION").build())));
        }
        catch (ToolingException e) {
            throw e;
        }
        catch (Exception e) {
            return ValueUtils.toFailureValueResultDTO(e);
        }
    }

    private org.mule.runtime.api.value.ValueResult cloneAndEnrichValues(org.mule.runtime.api.value.ValueResult valueResult, ComponentAst componentAst, String providerName) {
        if (!valueResult.isSuccess()) {
            return valueResult;
        }
        return org.mule.runtime.api.value.ValueResult.resultFrom(valueResult.getValues().stream().map(option -> ValueProviderUtils.cloneAndEnrichValue((Value)option, (List)componentAst.getModel(ParameterizedModel.class).map(parameterizedModel -> this.getParameters((ParameterizedModel)parameterizedModel, providerName)).orElseThrow(() -> new IllegalStateException("Component: '%s' is not a parameterized model: " + componentAst.getLocation()))).build()).collect(Collectors.toSet()));
    }

    private List<ParameterModel> getParameters(ParameterizedModel parameterizedModel, String valueName) {
        return parameterizedModel.getAllParameterModels().stream().filter(parameterModel -> parameterModel.getValueProviderModel().map(provider -> provider.getProviderName().equals(valueName)).orElse(false)).collect(Collectors.toList());
    }

    public Feature<Action<ValueProviderDisposeRequest>> disposeCachedValues() {
        return Feature.enabled(new DispacheableAction<ValueProviderDisposeRequest>(request -> ((ComponentLocator)this.locator.get()).get(Location.builderFromStringRepresentation((String)request.getLocation().toString()).build()).ifPresent(componentAst -> ((ValueProviderCache)this.valueProviderCache.get()).dispose((ComponentAst)componentAst, request.getParameterNames())), ValueProviderDisposeRequest.class, this.serializer));
    }

    protected abstract org.mule.runtime.api.value.ValueResult doGetValue(ValueProviderRequest var1);

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getValues": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(ValueProviderRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                ValueProviderRequest valueProviderRequest = (ValueProviderRequest)this.serializer.deserialize(arguments[0]);
                return this.serializer.serialize((Object)this.getValues(valueProviderRequest));
            }
            case "disposeCachedValues": {
                return this.disposeCachedValues();
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

