/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.ApplicationModelFactory;

public class DefaultApplicationModelFactory
implements ApplicationModelFactory {
    @Override
    public Optional<ArtifactAst> createApplicationModel(DeployableArtifactDescriptor deployableArtifactDescriptor, Set<ExtensionModel> extensionModels, ClassLoader applicationClassLoader, Function<ArtifactAst, UnaryOperator<String>> configurationPropertiesResolver, Map<String, String> deploymentProperties) {
        AstXmlParser astXmlParser = AstXmlParser.builder().withSchemaValidationsDisabled().withExtensionModels(extensionModels).withPropertyResolver(propertyKey -> deploymentProperties.getOrDefault(propertyKey, propertyKey)).build();
        return this.createApplicationModel(deployableArtifactDescriptor, astXmlParser, applicationClassLoader, configurationPropertiesResolver);
    }

    @Override
    public Optional<ArtifactAst> createApplicationModel(DeployableArtifactDescriptor deployableArtifactDescriptor, AstXmlParser parser, ClassLoader applicationClassLoader, Function<ArtifactAst, UnaryOperator<String>> configurationPropertiesResolver) {
        try {
            return Optional.of(this.loadApplicationModel(deployableArtifactDescriptor, parser, applicationClassLoader, configurationPropertiesResolver));
        }
        catch (Exception e) {
            throw new ToolingException("Error while creating application model", (Throwable)e);
        }
    }

    private ArtifactAst loadApplicationModel(DeployableArtifactDescriptor deployableArtifactDescriptor, AstXmlParser astXmlParser, ClassLoader applicationClassLoader, Function<ArtifactAst, UnaryOperator<String>> configurationPropertiesResolver) {
        List appXmlConfigInputStreams = deployableArtifactDescriptor.getConfigResources().stream().map(configFile -> {
            URL url = applicationClassLoader.getResource((String)configFile);
            if (url == null) {
                throw new ToolingException(String.format("Configuration file '%s' cannot be found", configFile));
            }
            try {
                return new Pair(configFile, (Object)url.openStream());
            }
            catch (IOException e) {
                throw new ToolingException(String.format("Error while reading configuration file '%s'", configFile), (Throwable)e);
            }
        }).collect(Collectors.toList());
        return (ArtifactAst)ClassUtils.withContextClassLoader((ClassLoader)applicationClassLoader, () -> {
            ArtifactAst ast = astXmlParser.parse(appXmlConfigInputStreams);
            UnaryOperator resolver = (UnaryOperator)configurationPropertiesResolver.apply(ast);
            try {
                LifecycleUtils.initialiseIfNeeded((Object)resolver);
            }
            catch (InitialisationException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            ast.updatePropertiesResolver(resolver);
            return ast;
        });
    }
}

