/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.factory;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.jetbrains.annotations.NotNull;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.IdentifiableElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ArtifactDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.api.request.session.DeclarationSessionCreationRequest;
import org.mule.tooling.api.request.session.model.Exclusion;
import org.mule.tooling.client.api.descriptors.dependency.Dependency;
import org.mule.tooling.client.internal.session.DeclarationSessionConfig;
import org.mule.tooling.client.internal.session.ExtensionModelProvider;
import org.mule.tooling.client.internal.session.factory.RemoteDeclarationSessionDeployment;

public class RemoteDeclarationSessionProvider {
    private LazyValue<RemoteDeclarationSessionDeployment> declarationSessionDeploymentLazyValue = new LazyValue(() -> {
        ArtifactDeclarer artifactDeclarer = ElementDeclarer.newArtifact();
        sessionConfig.getConfigurationElementDeclarations().stream().forEach(configurationElementDeclaration -> artifactDeclarer.withGlobalElement((GlobalElementDeclaration)configurationElementDeclaration));
        sessionConfig.getGlobalParameterDeclarations().stream().forEach(globalParameterDeclaration -> artifactDeclarer.withGlobalElement((GlobalElementDeclaration)globalParameterDeclaration));
        try {
            this.validateRequiredParameters(extensionModelProvider, sessionConfig);
            return RemoteDeclarationSessionDeployment.success(runtimeToolingService.createDeclarationSession(new DeclarationSessionCreationRequest(sessionConfig.getDependencies().stream().map(dependency -> RemoteDeclarationSessionProvider.toAgentPluginDependency(dependency)).collect(Collectors.toList()), (ArtifactDeclaration)artifactDeclarer.getDeclaration(), sessionConfig.getSessionProperties())));
        }
        catch (Exception e) {
            return RemoteDeclarationSessionDeployment.failure(e);
        }
    });

    public RemoteDeclarationSessionProvider(ExtensionModelProvider extensionModelProvider, RuntimeToolingService runtimeToolingService, DeclarationSessionConfig sessionConfig) {
    }

    public RemoteDeclarationSessionDeployment getRemoteDeclarationSession() {
        return (RemoteDeclarationSessionDeployment)this.declarationSessionDeploymentLazyValue.get();
    }

    public boolean isDeployed() {
        return this.declarationSessionDeploymentLazyValue.isComputed() && ((RemoteDeclarationSessionDeployment)this.declarationSessionDeploymentLazyValue.get()).isSuccess();
    }

    private void validateRequiredParameters(ExtensionModelProvider extensionModelProvider, DeclarationSessionConfig sessionConfig) {
        sessionConfig.getConfigurationElementDeclarations().forEach(configurationElementDeclaration -> {
            ExtensionModel extensionModel = this.validateIdentifiableElementDeclaration(extensionModelProvider, (IdentifiableElementDeclaration)configurationElementDeclaration);
            ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModel(configurationElementDeclaration.getName()).orElseThrow(() -> new ValidationException(String.format("Could not find component: '%s:%s'", configurationElementDeclaration.getDeclaringExtension(), configurationElementDeclaration.getName())));
            this.validateRequiredParameters((ParameterizedElementDeclaration)configurationElementDeclaration, (ParameterizedModel)configurationModel, Optional.of("name"), Optional.of(configurationElementDeclaration.getRefName()), Optional.empty());
            configurationElementDeclaration.getConnection().ifPresent(connectionElementDeclaration -> this.validateConnectionElementDeclaration(extensionModelProvider, (ConnectionElementDeclaration)connectionElementDeclaration, configurationElementDeclaration.getRefName()));
        });
        sessionConfig.getGlobalParameterDeclarations().forEach(globalParameter -> {
            if (globalParameter.getValue() == null) {
                throw new ValidationException(String.format("GlobalParameter with refName: '%s' for '%s:%s' does not has a value", globalParameter.getRefName(), globalParameter.getDeclaringExtension(), globalParameter.getName()));
            }
        });
    }

    private void validateRequiredParameters(ParameterizedElementDeclaration parameterizedElementDeclaration, ParameterizedModel parameterizedModel, Optional<String> nameProviderParameter, Optional<String> refName, Optional<String> containerElementName) {
        Set declaredParameterNames = parameterizedElementDeclaration.getParameterGroups().stream().flatMap(parameterGroupElementDeclaration -> parameterGroupElementDeclaration.getParameters().stream()).map(parameterElementDeclaration -> parameterElementDeclaration.getName()).collect(Collectors.toSet());
        nameProviderParameter.ifPresent(nameParameter -> declaredParameterNames.add(nameParameter));
        Optional<ParameterModel> missingRequiredParameter = parameterizedModel.getAllParameterModels().stream().filter(parameterModel -> parameterModel.isRequired()).filter(parameterModel -> !declaredParameterNames.contains(parameterModel.getName())).findFirst();
        if (missingRequiredParameter.isPresent()) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("Parameter '%s' is required but was not found on element: '%s:%s'");
            refName.ifPresent(ref -> messageBuilder.append(", refName: '").append((String)ref).append("'"));
            containerElementName.ifPresent(containerName -> messageBuilder.append(", containerElement: '").append((String)containerName).append("'"));
            throw new ValidationException(String.format(messageBuilder.toString(), missingRequiredParameter.get().getName(), parameterizedElementDeclaration.getDeclaringExtension(), parameterizedElementDeclaration.getName()));
        }
    }

    private void validateConnectionElementDeclaration(ExtensionModelProvider extensionModelProvider, ConnectionElementDeclaration connectionElementDeclaration, String containerRefName) {
        ExtensionModel extensionModel = this.validateIdentifiableElementDeclaration(extensionModelProvider, (IdentifiableElementDeclaration)connectionElementDeclaration);
        Optional<ConnectionProviderModel> connectionProviderModel = extensionModel.getConnectionProviders().stream().filter(cp -> cp.getName().equals(connectionElementDeclaration.getName())).findFirst();
        if (!connectionProviderModel.isPresent()) {
            connectionProviderModel = extensionModel.getConfigurationModels().stream().flatMap(cm -> cm.getConnectionProviders().stream()).filter(cp -> cp.getName().equals(connectionElementDeclaration.getName())).findFirst();
        }
        if (!connectionProviderModel.isPresent()) {
            throw new ValidationException(String.format("Could not find component: '%s:%s'", connectionElementDeclaration.getDeclaringExtension(), connectionElementDeclaration.getName()));
        }
        this.validateRequiredParameters((ParameterizedElementDeclaration)connectionElementDeclaration, (ParameterizedModel)connectionProviderModel.get(), Optional.empty(), Optional.empty(), Optional.of(containerRefName));
    }

    @NotNull
    private ExtensionModel validateIdentifiableElementDeclaration(ExtensionModelProvider extensionModelProvider, IdentifiableElementDeclaration elementDeclaration) {
        String declaringExtension = elementDeclaration.getDeclaringExtension();
        return extensionModelProvider.get(declaringExtension).orElseThrow(() -> new ValidationException(String.format("ElementDeclaration is defined for extension: '%s' which is not part of the context: '%s'", declaringExtension, extensionModelProvider.getAllNames())));
    }

    private static org.mule.tooling.api.request.session.model.Dependency toAgentPluginDependency(Dependency fromDependency) {
        org.mule.tooling.api.request.session.model.Dependency toDependency = new org.mule.tooling.api.request.session.model.Dependency();
        toDependency.setGroupId(fromDependency.getGroupId());
        toDependency.setArtifactId(fromDependency.getArtifactId());
        toDependency.setVersion(fromDependency.getVersion());
        toDependency.setClassifier(fromDependency.getClassifier());
        toDependency.setType(fromDependency.getType());
        toDependency.setScope(fromDependency.getScope());
        toDependency.setSystemPath(fromDependency.getSystemPath());
        toDependency.setOptional(fromDependency.getOptional());
        toDependency.setExclusions(fromDependency.getExclusions().stream().map(fromExclusion -> {
            Exclusion toExclusion = new Exclusion();
            toExclusion.setGroupId(fromExclusion.getGroupId());
            toExclusion.setArtifactId(fromExclusion.getArtifactId());
            return toExclusion;
        }).collect(Collectors.toList()));
        return toDependency;
    }
}

