/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.monitoring;

import com.google.inject.Inject;
import com.mulesoft.agent.domain.monitoring.JMXBean;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.MonitoringService;
import java.util.NoSuchElementException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Named(value="monitoring.request.handler")
@Path(value="monitoring")
@Singleton
public class MonitoringRequestHandler
extends ConfigurableExternalHandler {
    @Inject
    protected MonitoringService monitoringService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getBeans() {
        if (this.isEnabled()) {
            try {
                return Response.ok().entity((Object)this.monitoringService.getTrackedBeans()).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addBeans(JMXBean[] beans) {
        if (this.isEnabled()) {
            try {
                this.monitoringService.addTrackedBeans(beans);
                return Response.ok().build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response removeBeans(JMXBean[] beans) {
        if (this.isEnabled()) {
            try {
                this.monitoringService.removeTrackedBeans(beans);
                return Response.ok().build();
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }
}

