/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.properties;

import com.google.inject.Inject;
import com.mulesoft.agent.domain.properties.MuleProperty;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.PropertiesService;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Named(value="properties.request.handler")
@Path(value="properties")
@Singleton
public class PropertiesRequestHandler
extends ConfigurableExternalHandler {
    @Inject
    protected PropertiesService propertiesService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getProperties() {
        if (this.isEnabled()) {
            try {
                return Response.ok().entity((Object)this.propertiesService.getProperties()).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response setProperties(Map<String, String> properties, @DefaultValue(value="true") @QueryParam(value="override") boolean override) {
        if (this.isEnabled()) {
            try {
                return Response.ok().entity((Object)this.propertiesService.setProperties(properties, override)).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @GET
    @Path(value="{propertyName}")
    @Produces(value={"application/json"})
    public Response getProperty(@PathParam(value="propertyName") String propertyName) {
        if (this.isEnabled()) {
            try {
                return Response.ok().entity((Object)this.propertiesService.getProperty(propertyName)).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @PUT
    @Path(value="{propertyName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response setProperty(@PathParam(value="propertyName") String propertyName, MuleProperty property) {
        if (this.isEnabled()) {
            try {
                return Response.ok().entity((Object)this.propertiesService.setProperty(propertyName, property.getValue(), property.isOverride())).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @DELETE
    @Path(value="{propertyName}")
    @Produces(value={"application/json"})
    public Response clearProperty(@PathParam(value="propertyName") String propertyName) {
        if (this.isEnabled()) {
            try {
                this.propertiesService.clearProperty(propertyName);
                return Response.noContent().build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }
}

