/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.internal.DefaultComponentGenerationInformation;
import org.mule.runtime.ast.internal.DefaultComponentParameterAst;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntaxBuilder;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.internal.loader.util.InfrastructureTypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationModelTypeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModelTypeUtils.class);
    private static final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    private ApplicationModelTypeUtils() {
    }

    public static void resolveTypedComponentIdentifier(final DefaultComponentAstBuilder componentAstBuilder, boolean topLevel, final ExtensionModelHelper extensionModelHelper) {
        LOGGER.debug("resolveTypedComponentIdentifier for {}", (Object)componentAstBuilder);
        if (componentAstBuilder.getExtensionModel() != null) {
            extensionModelHelper.walkToComponent(componentAstBuilder.getIdentifier(), topLevel, new ExtensionModelHelper.ExtensionWalkerModelDelegate(){

                @Override
                public void onConfiguration(ConfigurationModel model) {
                    componentAstBuilder.withConfigurationModel(model);
                    ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, (NamedObject)model, model.getParameterGroupModels(), extensionModelHelper);
                }

                @Override
                public void onConnectionProvider(ConnectionProviderModel model) {
                    componentAstBuilder.withConnectionProviderModel(model);
                    ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, (NamedObject)model, model.getParameterGroupModels(), extensionModelHelper);
                }

                @Override
                public void onOperation(OperationModel model) {
                    componentAstBuilder.withComponentModel((ComponentModel)model);
                    ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, (NamedObject)model, model.getParameterGroupModels(), extensionModelHelper);
                }

                @Override
                public void onSource(SourceModel model) {
                    componentAstBuilder.withComponentModel((ComponentModel)model);
                    ArrayList sourceParamGroups = new ArrayList();
                    sourceParamGroups.addAll(model.getParameterGroupModels());
                    model.getSuccessCallback().ifPresent(scb -> sourceParamGroups.addAll(scb.getParameterGroupModels()));
                    model.getErrorCallback().ifPresent(ecb -> sourceParamGroups.addAll(ecb.getParameterGroupModels()));
                    ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, (NamedObject)model, sourceParamGroups, extensionModelHelper);
                }

                @Override
                public void onConstruct(ConstructModel model) {
                    componentAstBuilder.withComponentModel((ComponentModel)model);
                    ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, (NamedObject)model, model.getParameterGroupModels(), extensionModelHelper);
                }

                @Override
                public void onNestableElement(NestableElementModel model) {
                    componentAstBuilder.withNestableElementModel(model);
                    ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, (NamedObject)model, model.getParameterGroupModels(), extensionModelHelper);
                }

                @Override
                public void onType(MetadataType type) {
                    type.accept(new MetadataTypeVisitor(){

                        public void visitObject(ObjectType objectType) {
                            MetadataTypeModelAdapter model = MetadataTypeModelAdapter.createMetadataTypeModelAdapterWithSterotype((MetadataType)objectType, extensionModelHelper).orElseGet(() -> MetadataTypeModelAdapter.createParameterizedTypeModelAdapter((MetadataType)objectType, extensionModelHelper));
                            componentAstBuilder.withParameterizedModel(model);
                            ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, (NamedObject)model, model.getParameterGroupModels(), extensionModelHelper);
                        }

                        public void visitArrayType(ArrayType arrayType) {
                            arrayType.getType().accept((MetadataTypeVisitor)this);
                        }

                        public void visitUnion(UnionType unionType) {
                            unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
                        }
                    });
                }
            }, componentAstBuilder.getExtensionModel());
        }
        if (!componentAstBuilder.getModel(HasStereotypeModel.class).isPresent()) {
            InfrastructureTypeMapping.getTypeFor((ComponentIdentifier)componentAstBuilder.getIdentifier()).flatMap(extensionModelHelper::findMetadataType).ifPresent(type -> {
                MetadataTypeModelAdapter model = MetadataTypeModelAdapter.createMetadataTypeModelAdapterWithSterotype(type, extensionModelHelper).orElseGet(() -> MetadataTypeModelAdapter.createParameterizedTypeModelAdapter(type, extensionModelHelper));
                componentAstBuilder.withParameterizedModel(model);
                extensionModelHelper.resolveDslElementModel((MetadataType)type, componentAstBuilder.getExtensionModel()).ifPresent(s -> componentAstBuilder.getGenerationInformation().withSyntax((DslElementSyntax)s));
                ApplicationModelTypeUtils.onParameterizedModel(componentAstBuilder, (NamedObject)model, model.getParameterGroupModels(), extensionModelHelper);
            });
        }
        componentAstBuilder.withComponentType(extensionModelHelper.findComponentType(componentAstBuilder.getIdentifier()));
    }

    private static void onParameterizedModel(DefaultComponentAstBuilder componentModel, NamedObject model, List<ParameterGroupModel> paramGroups, ExtensionModelHelper extensionModelHelper) {
        DslElementSyntax elementDsl = componentModel.getType() != null ? extensionModelHelper.resolveDslElementModel(componentModel.getType(), componentModel.getExtensionModel()).orElseGet(() -> extensionModelHelper.resolveDslElementModel(model, componentModel.getIdentifier())) : extensionModelHelper.resolveDslElementModel(model, componentModel.getIdentifier());
        componentModel.getGenerationInformation().withSyntax(elementDsl);
        Multimap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents = ApplicationModelTypeUtils.getNestedComponents(componentModel);
        List inlineGroupedParameters = paramGroups.stream().filter(ParameterGroupModel::isShowInDsl).map(group -> ApplicationModelTypeUtils.addInlineGroup(componentModel, nestedComponents, group, extensionModelHelper)).flatMap(k -> k.getParameterModels().stream().map(v -> new Pair(v, k))).collect(Collectors.toList());
        List<Pair<ParameterModel, ParameterGroupModel>> parameters = paramGroups.stream().flatMap(k -> k.getParameterModels().stream().map(v -> new Pair(v, k))).distinct().collect(Collectors.toList());
        parameters.stream().filter(paramModel -> !inlineGroupedParameters.contains(paramModel)).forEach(paramModel -> elementDsl.getAttribute(((ParameterModel)paramModel.getFirst()).getName()).ifPresent(attrDsl -> {
            if (ApplicationModelTypeUtils.setSimpleParameterValue(componentModel, componentModel, (ParameterModel)paramModel.getFirst(), (ParameterGroupModel)paramModel.getSecond(), attrDsl, nestedComponents)) {
                inlineGroupedParameters.add(paramModel);
            }
        }));
        ApplicationModelTypeUtils.handleNestedParameters(componentModel, nestedComponents, extensionModelHelper, parameters, parameterModel -> !inlineGroupedParameters.contains(parameterModel));
    }

    private static ParameterGroupModel addInlineGroup(DefaultComponentAstBuilder componentModel, Multimap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents, ParameterGroupModel group, ExtensionModelHelper extensionModelHelper) {
        componentModel.getGenerationInformation().getSyntax().getChild(group.getName()).ifPresent(groupDsl -> {
            Optional<ComponentIdentifier> groupIdentifier = ApplicationModelTypeUtils.getIdentifier(groupDsl);
            if (!groupIdentifier.isPresent()) {
                return;
            }
            DefaultComponentAstBuilder groupComponent = ApplicationModelTypeUtils.getSingleComponentModel(nestedComponents, groupIdentifier);
            if (groupComponent != null) {
                groupComponent.getGenerationInformation().withSyntax((DslElementSyntax)groupDsl);
                ArrayList inlineGroupedParameters = new ArrayList();
                group.getParameterModels().stream().filter(paramModel -> groupComponent.getRawParameters().containsKey(paramModel.getName())).forEach(paramModel -> groupDsl.getAttribute(paramModel.getName()).ifPresent(attr -> {
                    if (ApplicationModelTypeUtils.setSimpleParameterValue(componentModel, groupComponent, paramModel, group, attr, nestedComponents)) {
                        inlineGroupedParameters.add(new Pair(paramModel, (Object)group));
                    }
                }));
                ApplicationModelTypeUtils.handleNestedParameters(componentModel, ApplicationModelTypeUtils.getNestedComponents(groupComponent), extensionModelHelper, group.getParameterModels().stream().map(k -> new Pair(k, (Object)group)).collect(Collectors.toList()), parameterModel -> !inlineGroupedParameters.contains(parameterModel));
            }
        });
        return group;
    }

    private static void handleNestedParameters(DefaultComponentAstBuilder componentModel, Multimap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents, ExtensionModelHelper extensionModelHelper, List<Pair<ParameterModel, ParameterGroupModel>> parameters, Predicate<Pair<ParameterModel, ParameterGroupModel>> parameterModelFilter) {
        parameters.stream().filter(parameterModelFilter).filter(paramModel -> ((ParameterModel)paramModel.getFirst()).getDslConfiguration() != null && ((ParameterModel)paramModel.getFirst()).getDslConfiguration().allowsInlineDefinition()).forEach(paramModel -> {
            DslElementSyntax paramSyntax = extensionModelHelper.resolveDslElementModel((ParameterModel)paramModel.getFirst(), componentModel.getIdentifier());
            ApplicationModelTypeUtils.getIdentifier(paramSyntax).ifPresent(id -> ApplicationModelTypeUtils.handleNestedExtensionParameter(componentModel, nestedComponents, extensionModelHelper, (Pair<ParameterModel, ParameterGroupModel>)paramModel, paramSyntax, nestedComponents.get(id)));
        });
    }

    private static void handleNestedExtensionParameter(final DefaultComponentAstBuilder componentModel, final Multimap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents, final ExtensionModelHelper extensionModelHelper, final Pair<ParameterModel, ParameterGroupModel> paramModel, final DslElementSyntax paramSyntax, final Collection<DefaultComponentAstBuilder> nestedForId) {
        ((ParameterModel)paramModel.getFirst()).getType().accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                if (ExtensionModelUtils.isContent((ParameterModel)((ParameterModel)paramModel.getFirst())) || ((ParameterModel)paramModel.getFirst()).getExpressionSupport() == ExpressionSupport.REQUIRED) {
                    this.addParameterUsingTextContent(componentModel, nestedForId);
                } else {
                    ApplicationModelTypeUtils.enrichComponentModels(componentModel, (Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)nestedComponents, Optional.of(paramSyntax), (ParameterModel)paramModel.getFirst(), (ParameterGroupModel)paramModel.getSecond(), metadataType, true, extensionModelHelper);
                }
            }

            public void visitUnion(UnionType unionType) {
                if (ExtensionModelUtils.isContent((ParameterModel)((ParameterModel)paramModel.getFirst())) || ((ParameterModel)paramModel.getFirst()).getExpressionSupport() == ExpressionSupport.REQUIRED) {
                    this.addParameterUsingTextContent(componentModel, nestedForId);
                } else {
                    unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
                }
            }

            public void visitSimpleType(SimpleType stringType) {
                this.addParameterUsingTextContent(componentModel, nestedForId);
            }

            private void addParameterUsingTextContent(DefaultComponentAstBuilder componentModel2, Collection<DefaultComponentAstBuilder> nestedForId2) {
                nestedForId2.forEach(childComp -> {
                    String body = childComp.getRawParameters().get("$%body%$");
                    body = body == null ? this.resolveNullBody((DefaultComponentAstBuilder)childComp) : this.resolveNonNullBody(body, (DefaultComponentAstBuilder)childComp);
                    componentModel2.withParameter((ParameterModel)paramModel.getFirst(), (ParameterGroupModel)paramModel.getSecond(), new DefaultComponentParameterAst(body, (ParameterModel)paramModel.getFirst(), (ParameterGroupModel)paramModel.getSecond(), childComp.getMetadata(), DefaultComponentGenerationInformation.builder().withSyntax(paramSyntax).build(), componentModel2.getPropertiesResolver()), Optional.of(childComp.getIdentifier()));
                });
            }

            private String resolveNullBody(DefaultComponentAstBuilder childComp) {
                if (this.isCdata(childComp)) {
                    return "";
                }
                return null;
            }

            private String resolveNonNullBody(String body, DefaultComponentAstBuilder childComp) {
                if (this.isCdata(childComp)) {
                    return body;
                }
                return body.trim();
            }

            protected boolean isCdata(DefaultComponentAstBuilder childComp) {
                return Boolean.TRUE.equals(childComp.getMetadata().getParserAttributes().get("IS_CDATA"));
            }
        });
    }

    private static Multimap<ComponentIdentifier, DefaultComponentAstBuilder> getNestedComponents(DefaultComponentAstBuilder componentModel) {
        ArrayListMultimap result = ArrayListMultimap.create();
        componentModel.childComponentsStream().forEach(arg_0 -> ApplicationModelTypeUtils.lambda$getNestedComponents$22((Multimap)result, arg_0));
        return result;
    }

    private static DefaultComponentAstBuilder getSingleComponentModel(Multimap<ComponentIdentifier, DefaultComponentAstBuilder> innerComponents, Optional<ComponentIdentifier> identifier) {
        return identifier.filter(arg_0 -> innerComponents.containsKey(arg_0)).map(arg_0 -> innerComponents.get(arg_0)).map(collection -> (DefaultComponentAstBuilder)collection.iterator().next()).orElse(null);
    }

    private static void enrichComponentModels(DefaultComponentAstBuilder component, Multimap<ComponentIdentifier, DefaultComponentAstBuilder> innerComponents, Optional<DslElementSyntax> optionalParamDsl, ParameterModel paramModel, ParameterGroupModel parameterGroupModel, MetadataType paramConcreteType, ExtensionModelHelper extensionModelHelper) {
        ApplicationModelTypeUtils.enrichComponentModels(component, innerComponents, optionalParamDsl, paramModel, parameterGroupModel, paramConcreteType, false, extensionModelHelper);
    }

    private static void enrichComponentModels(DefaultComponentAstBuilder componentModel, Multimap<ComponentIdentifier, DefaultComponentAstBuilder> innerComponents, Optional<DslElementSyntax> optionalParamDsl, ParameterModel paramModel, ParameterGroupModel parameterGroupModel, MetadataType paramConcreteType, boolean useConcreteTypeForUnion, ExtensionModelHelper extensionModelHelper) {
        if (!optionalParamDsl.isPresent()) {
            return;
        }
        DslElementSyntax paramDsl = optionalParamDsl.get();
        DefaultComponentAstBuilder paramComponent = null;
        if (!ApplicationModelTypeUtils.isNoWrapperParam(paramModel) && (paramComponent = ApplicationModelTypeUtils.getSingleComponentModel(innerComponents, ApplicationModelTypeUtils.getIdentifier(paramDsl))) == null && !StringUtils.isEmpty((CharSequence)paramDsl.getPrefix()) && (paramDsl = extensionModelHelper.resolveDslElementModel(paramConcreteType, paramDsl.getPrefix()).orElse(paramDsl)) != null && (paramComponent = ApplicationModelTypeUtils.getSingleComponentModel(innerComponents, ApplicationModelTypeUtils.getIdentifier(paramDsl))) == null && componentModel.getIdentifier() != null) {
            paramComponent = ApplicationModelTypeUtils.getSingleComponentModel(innerComponents, ApplicationModelTypeUtils.getIdentifier(optionalParamDsl.get().getElementName(), componentModel.getIdentifier().getNamespace()));
        }
        if (paramDsl != null) {
            if (ApplicationModelTypeUtils.isNoWrapperParam(paramModel)) {
                paramModel.getType().accept(ApplicationModelTypeUtils.getComponentChildVisitor(componentModel, paramModel, parameterGroupModel, paramDsl, componentModel, extensionModelHelper, innerComponents));
            } else if (paramComponent != null) {
                paramComponent.getGenerationInformation().withSyntax(paramDsl);
                if (paramDsl.isWrapped()) {
                    ApplicationModelTypeUtils.handleWrappedElement(componentModel, paramComponent, paramModel, parameterGroupModel, paramConcreteType, useConcreteTypeForUnion, paramDsl, extensionModelHelper);
                } else {
                    paramModel.getType().accept(ApplicationModelTypeUtils.getComponentChildVisitor(componentModel, paramModel, parameterGroupModel, paramDsl, paramComponent, extensionModelHelper, innerComponents));
                }
            } else {
                ApplicationModelTypeUtils.setSimpleParameterValue(componentModel, componentModel, paramModel, parameterGroupModel, optionalParamDsl.get(), innerComponents);
            }
        }
    }

    private static boolean isNoWrapperParam(ParameterModel paramModel) {
        return paramModel.getModelProperty(NoWrapperModelProperty.class).isPresent();
    }

    private static void handleWrappedElement(final DefaultComponentAstBuilder componentModel, DefaultComponentAstBuilder wrappedComponent, final ParameterModel paramModel, final ParameterGroupModel parameterGroupModel, final MetadataType paramConcreteType, final boolean useConcreteTypeForUnion, final DslElementSyntax paramDsl, final ExtensionModelHelper extensionModelHelper) {
        final Multimap<ComponentIdentifier, DefaultComponentAstBuilder> nestedWrappedComponents = ApplicationModelTypeUtils.getNestedComponents(wrappedComponent);
        paramModel.getType().accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                extensionModelHelper.resolveSubTypes((ObjectType)paramModel.getType()).entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent() && ApplicationModelTypeUtils.getSingleComponentModel((Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)nestedWrappedComponents, ApplicationModelTypeUtils.getIdentifier((DslElementSyntax)((Optional)entry.getValue()).get())) != null).findFirst().ifPresent(wrappedEntryType -> {
                    DslElementSyntax wrappedDsl = (DslElementSyntax)((Optional)wrappedEntryType.getValue()).get();
                    ((ObjectType)wrappedEntryType.getKey()).accept(ApplicationModelTypeUtils.getComponentChildVisitor(componentModel, paramModel, parameterGroupModel, wrappedDsl, ApplicationModelTypeUtils.getSingleComponentModel((Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)nestedWrappedComponents, ApplicationModelTypeUtils.getIdentifier(wrappedDsl)), extensionModelHelper, (Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)nestedWrappedComponents));
                });
            }

            public void visitUnion(UnionType unionType) {
                if (useConcreteTypeForUnion) {
                    this.doVisitUnionType(paramConcreteType);
                } else {
                    unionType.getTypes().forEach(this::doVisitUnionType);
                }
            }

            protected void doVisitUnionType(MetadataType type) {
                ((Collection)MetadataTypeUtils.getTypeId((MetadataType)type).flatMap(arg_0 -> ((DslElementSyntax)paramDsl).getChild(arg_0)).flatMap(x$0 -> ApplicationModelTypeUtils.getIdentifier(x$0)).flatMap(childComponentId -> Optional.ofNullable(nestedWrappedComponents.get(childComponentId))).orElse(Collections.emptySet())).forEach(nestedChild -> type.accept(ApplicationModelTypeUtils.getComponentChildVisitor(componentModel, paramModel, parameterGroupModel, paramDsl, nestedChild, extensionModelHelper, (Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)nestedWrappedComponents)));
            }
        });
    }

    private static boolean setSimpleParameterValue(DefaultComponentAstBuilder componentTo, DefaultComponentAstBuilder componentFrom, ParameterModel paramModel, ParameterGroupModel paramGroupModel, DslElementSyntax paramDsl, Multimap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents) {
        String value = paramDsl.supportsAttributeDeclaration() ? componentFrom.getRawParameters().get(ApplicationModelTypeUtils.getInfrastructureParameterName(paramModel.getType()).orElse(paramModel.getName())) : null;
        Optional<ComponentIdentifier> paramIdentifier = Optional.empty();
        if (StringUtils.isBlank(value) && ExtensionModelUtils.isContent((ParameterModel)paramModel)) {
            value = componentFrom.getRawParameters().get("$%body%$");
            paramIdentifier = Optional.of(componentFrom.getIdentifier());
        }
        if (StringUtils.isNotBlank(value)) {
            boolean trim;
            boolean bl = trim = !paramDsl.supportsAttributeDeclaration() || !componentTo.disableTrimWhitespaces();
            if (trim) {
                value = value.trim();
            }
            DefaultComponentParameterAst paramValue = new DefaultComponentParameterAst(value, paramModel, paramGroupModel, componentFrom.getMetadata(), DefaultComponentGenerationInformation.builder().withSyntax(paramDsl).build(), componentFrom.getPropertiesResolver());
            Optional<ComponentIdentifier> childParamId = ApplicationModelTypeUtils.getIdentifier(paramDsl);
            if (childParamId.map(paramId -> nestedComponents.containsKey(paramId)).orElse(false).booleanValue()) {
                if (paramValue.isDefaultValue()) {
                    return false;
                }
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("[%s:%d]: Component '%s' has a child element '%s' which is used for the same purpose of the configuration parameter '%s'. Only one must be used.", componentTo.getMetadata().getFileName().orElse("unknown"), componentTo.getMetadata().getStartLine().orElse(-1), componentFrom.getIdentifier(), childParamId.get(), paramModel.getName())));
            }
            componentTo.withParameter(paramModel, paramGroupModel, paramValue, paramIdentifier);
            return true;
        }
        return false;
    }

    private static MetadataTypeVisitor getComponentChildVisitor(final DefaultComponentAstBuilder componentModel, final ParameterModel paramModel, final ParameterGroupModel parameterGroupModel, final DslElementSyntax paramDsl, final DefaultComponentAstBuilder paramComponent, final ExtensionModelHelper extensionModelHelper, final Multimap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents) {
        return new MetadataTypeVisitor(){

            public void visitSimpleType(SimpleType simpleType) {
                DefaultComponentAstBuilder paramComponentFrom = ApplicationModelTypeUtils.getSingleComponentModel((Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)nestedComponents, ApplicationModelTypeUtils.getIdentifier(paramDsl));
                ApplicationModelTypeUtils.setSimpleParameterValue(componentModel, paramComponentFrom, paramModel, parameterGroupModel, paramDsl, (Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)ApplicationModelTypeUtils.getNestedComponents(paramComponentFrom));
            }

            public void visitArrayType(ArrayType arrayType) {
                MetadataType itemType = arrayType.getType();
                itemType.accept(ApplicationModelTypeUtils.getArrayItemTypeVisitor(componentModel, paramModel, parameterGroupModel, paramDsl, paramComponent, extensionModelHelper));
            }

            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    List componentModels = ApplicationModelTypeUtils.handleMapChild(paramDsl, paramComponent, parameterGroupModel, extensionModelHelper, objectType);
                    componentModel.withParameter(paramModel, parameterGroupModel, new DefaultComponentParameterAst(componentModels, paramModel, parameterGroupModel, paramComponent.getMetadata(), DefaultComponentGenerationInformation.builder().withSyntax(paramDsl).build(), componentModel.getPropertiesResolver()), Optional.of(paramComponent.getIdentifier()));
                    return;
                }
                componentModel.withParameter(paramModel, parameterGroupModel, new DefaultComponentParameterAst(paramComponent, paramModel, parameterGroupModel, paramComponent.getMetadata(), DefaultComponentGenerationInformation.builder().withSyntax(paramDsl).build(), componentModel.getPropertiesResolver()), ApplicationModelTypeUtils.getIdentifier(paramDsl));
                ParameterizedModel parameterizedModel = ApplicationModelTypeUtils.resolveParameterizedModel(extensionModelHelper, (MetadataType)objectType, paramComponent.getIdentifier());
                paramComponent.withParameterizedModel(parameterizedModel);
                paramComponent.getGenerationInformation().withSyntax(paramDsl);
                final Multimap nestedComponents2 = ApplicationModelTypeUtils.getNestedComponents(paramComponent);
                parameterizedModel.getParameterGroupModels().forEach(nestedGroup -> nestedGroup.getParameterModels().forEach(nestedParameter -> {
                    ApplicationModelTypeUtils.enrichComponentModels(paramComponent, (Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)nestedComponents2, paramDsl.getContainedElement(nestedParameter.getName()), nestedParameter, nestedGroup, nestedParameter.getType(), extensionModelHelper);
                    nestedParameter.getType().accept(new MetadataTypeVisitor((ParameterModel)nestedParameter, (ParameterGroupModel)nestedGroup){
                        final /* synthetic */ ParameterModel val$nestedParameter;
                        final /* synthetic */ ParameterGroupModel val$nestedGroup;
                        {
                            this.val$nestedParameter = parameterModel;
                            this.val$nestedGroup = parameterGroupModel;
                        }

                        public void visitUnion(UnionType unionType) {
                            unionType.getTypes().forEach(type -> ApplicationModelTypeUtils.enrichComponentModels(paramComponent, (Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)nestedComponents2, extensionModelHelper.resolveDslElementModel((MetadataType)type, paramDsl.getPrefix()), this.val$nestedParameter, this.val$nestedGroup, this.val$nestedParameter.getType(), extensionModelHelper));
                        }
                    });
                }));
            }

            public void visitUnion(UnionType unionType) {
                componentModel.withParameter(paramModel, parameterGroupModel, new DefaultComponentParameterAst(paramComponent, paramModel, parameterGroupModel, paramComponent.getMetadata(), DefaultComponentGenerationInformation.builder().withSyntax(paramDsl).build(), componentModel.getPropertiesResolver()), Optional.of(paramComponent.getIdentifier()));
                Multimap nestedComponents2 = ApplicationModelTypeUtils.getNestedComponents(paramComponent);
                unionType.getTypes().forEach(type -> {
                    ParameterizedModel innerTypeParameterizedModel = ApplicationModelTypeUtils.resolveParameterizedModel(extensionModelHelper, type, paramComponent.getIdentifier());
                    if (paramDsl.isWrapped()) {
                        paramDsl.getContainedElement(NameUtils.getAliasName((MetadataType)type)).ifPresent(innerParamDsl -> {
                            ParameterizedModel parameterizedModel = ApplicationModelTypeUtils.resolveParameterizedModel(extensionModelHelper, type, paramComponent.getIdentifier());
                            paramComponent.withParameterizedModel(parameterizedModel);
                            ExtensionModelUtils.getGroupAndParametersPairs((ParameterizedModel)innerTypeParameterizedModel).forEach(groupAndParam -> {
                                Collection children = ApplicationModelTypeUtils.getIdentifier(innerParamDsl).map(arg_0 -> ((Multimap)nestedComponents2).get(arg_0)).orElse(Collections.emptyList());
                                children.forEach(nested -> {
                                    nested.withParameterizedModel(innerTypeParameterizedModel);
                                    ApplicationModelTypeUtils.enrichComponentModels(nested, (Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)ApplicationModelTypeUtils.getNestedComponents(nested), innerParamDsl.getContainedElement(((ParameterModel)groupAndParam.getSecond()).getName()), (ParameterModel)groupAndParam.getSecond(), (ParameterGroupModel)groupAndParam.getFirst(), ((ParameterModel)groupAndParam.getSecond()).getType(), extensionModelHelper);
                                });
                            });
                        });
                    } else if (paramComponent.getIdentifier().getName().equals(innerTypeParameterizedModel.getName())) {
                        ParameterizedModel parameterizedModel = ApplicationModelTypeUtils.resolveParameterizedModel(extensionModelHelper, type, paramComponent.getIdentifier());
                        paramComponent.withParameterizedModel(parameterizedModel);
                        ExtensionModelUtils.getGroupAndParametersPairs((ParameterizedModel)innerTypeParameterizedModel).forEach(groupAndParam -> {
                            Optional containedElement = paramDsl.getContainedElement(((ParameterModel)groupAndParam.getSecond()).getName());
                            ApplicationModelTypeUtils.enrichComponentModels(paramComponent, (Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)nestedComponents2, containedElement, (ParameterModel)groupAndParam.getSecond(), (ParameterGroupModel)groupAndParam.getFirst(), ((ParameterModel)groupAndParam.getSecond()).getType(), extensionModelHelper);
                        });
                    }
                });
            }
        };
    }

    private static List<ComponentAstBuilder> handleMapChild(DslElementSyntax paramDsl, DefaultComponentAstBuilder paramComponent, ParameterGroupModel parameterGroupModel, ExtensionModelHelper extensionModelHelper, ObjectType objectType) {
        return paramComponent.childComponentsStream().filter(entryComponent -> {
            MetadataType entryType = (MetadataType)objectType.getOpenRestriction().get();
            Optional entryValueDslOptional = paramDsl.getGeneric(entryType);
            if (entryValueDslOptional.isPresent()) {
                DslElementSyntax entryValueDsl = (DslElementSyntax)entryValueDslOptional.get();
                entryComponent.getGenerationInformation().withSyntax(entryValueDsl);
                ImmutableParameterModel keyParamModel = new ImmutableParameterModel("key", "", typeLoader.load(String.class), false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, null, null, null, null, Collections.emptyList(), Collections.emptySet());
                ImmutableParameterModel valueParamModel = new ImmutableParameterModel("value", "", entryType, false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, null, null, null, null, Collections.emptyList(), Collections.emptySet());
                ImmutableParameterGroupModel keyMapEntryGroupModel = new ImmutableParameterGroupModel("General", "", Arrays.asList(keyParamModel, valueParamModel), Collections.emptyList(), false, null, null, Collections.emptySet());
                String key = entryComponent.getRawParameters().get("key");
                DefaultComponentGenerationInformation.Builder keyParamGenerationInfoBuilder = DefaultComponentGenerationInformation.builder();
                entryValueDsl.getAttribute("key").ifPresent(keyParamGenerationInfoBuilder::withSyntax);
                DefaultComponentGenerationInformation.Builder valueParamGenerationInfoBuilder = DefaultComponentGenerationInformation.builder();
                entryValueDsl.getAttribute("value").ifPresent(valueParamGenerationInfoBuilder::withSyntax);
                entryComponent.withParameter((ParameterModel)keyParamModel, (ParameterGroupModel)keyMapEntryGroupModel, new DefaultComponentParameterAst(key, (ParameterModel)keyParamModel, (ParameterGroupModel)keyMapEntryGroupModel, entryComponent.getMetadata(), keyParamGenerationInfoBuilder.build(), paramComponent.getPropertiesResolver()), Optional.empty());
                String value = entryComponent.getRawParameters().get("value");
                if (StringUtils.isBlank((CharSequence)value)) {
                    Optional genericValueDslOptional = entryValueDsl.getGeneric(keyParamModel.getType());
                    Multimap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents = ApplicationModelTypeUtils.getNestedComponents(entryComponent);
                    if (genericValueDslOptional.isPresent()) {
                        DslElementSyntax genericValueDsl = (DslElementSyntax)genericValueDslOptional.get();
                        List<ComponentAstBuilder> itemsComponentModels = entryComponent.childComponentsStream().filter(valueComponent -> valueComponent.getIdentifier().equals(ApplicationModelTypeUtils.getIdentifier(genericValueDsl).orElse(null))).map(arg_0 -> ApplicationModelTypeUtils.lambda$null$26(entryComponent, genericValueDsl, (ParameterModel)valueParamModel, keyMapEntryGroupModel, extensionModelHelper, arg_0)).collect(Collectors.toList());
                        entryComponent.withParameter((ParameterModel)valueParamModel, (ParameterGroupModel)keyMapEntryGroupModel, new DefaultComponentParameterAst(itemsComponentModels, (ParameterModel)valueParamModel, (ParameterGroupModel)keyMapEntryGroupModel, entryComponent.getMetadata(), valueParamGenerationInfoBuilder.build(), paramComponent.getPropertiesResolver()), Optional.of(paramComponent.getIdentifier()));
                    } else {
                        ApplicationModelTypeUtils.handleLaxMapEntry(extensionModelHelper, entryComponent, entryType, entryValueDsl, (ParameterModel)valueParamModel, (ParameterGroupModel)keyMapEntryGroupModel, nestedComponents);
                    }
                } else {
                    entryComponent.withParameter((ParameterModel)valueParamModel, (ParameterGroupModel)keyMapEntryGroupModel, new DefaultComponentParameterAst(value, (ParameterModel)valueParamModel, (ParameterGroupModel)keyMapEntryGroupModel, entryComponent.getMetadata(), valueParamGenerationInfoBuilder.build(), paramComponent.getPropertiesResolver()), Optional.empty());
                }
                entryComponent.withParameterizedModel(MetadataTypeModelAdapter.createKeyValueWrapperTypeModelAdapter(keyParamModel.getName(), keyParamModel.getType(), valueParamModel.getName(), valueParamModel.getType(), extensionModelHelper));
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    private static void handleLaxMapEntry(ExtensionModelHelper extensionModelHelper, DefaultComponentAstBuilder entryComponent, MetadataType entryType, DslElementSyntax entryValueDsl, ParameterModel valueParamModel, ParameterGroupModel parameterGroupModel, Multimap<ComponentIdentifier, DefaultComponentAstBuilder> nestedComponents) {
        Optional valueDslElementOptional = entryValueDsl.getContainedElement("value");
        if (valueDslElementOptional.isPresent() && !((DslElementSyntax)valueDslElementOptional.get()).isWrapped()) {
            ApplicationModelTypeUtils.enrichComponentModels(entryComponent, nestedComponents, valueDslElementOptional, valueParamModel, parameterGroupModel, valueParamModel.getType(), extensionModelHelper);
        } else if (entryType instanceof ObjectType) {
            extensionModelHelper.resolveSubTypes((ObjectType)entryType).entrySet().stream().filter(entrySubTypeDslOptional -> ((Optional)entrySubTypeDslOptional.getValue()).isPresent()).forEach(entrySubTypeDslOptional -> ApplicationModelTypeUtils.enrichComponentModels(entryComponent, nestedComponents, Optional.of(((Optional)entrySubTypeDslOptional.getValue()).get()), (ParameterModel)new ImmutableParameterModel("value", "", (MetadataType)entrySubTypeDslOptional.getKey(), false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, null, null, null, null, Collections.emptyList(), Collections.emptySet()), parameterGroupModel, (MetadataType)entrySubTypeDslOptional.getKey(), extensionModelHelper));
        }
    }

    private static MetadataTypeVisitor getArrayItemTypeVisitor(final DefaultComponentAstBuilder componentModel, final ParameterModel paramModel, final ParameterGroupModel parameterGroupModel, final DslElementSyntax paramDsl, final DefaultComponentAstBuilder paramComponent, final ExtensionModelHelper extensionModelHelper) {
        return new MetadataTypeVisitor(){

            public void visitSimpleType(SimpleType simpleType) {
                if (paramComponent.getRawParameters().containsKey("value")) {
                    paramComponent.withParameterizedModel(MetadataTypeModelAdapter.createSimpleWrapperTypeModelAdapter(simpleType, extensionModelHelper));
                    return;
                }
                paramDsl.getGeneric((MetadataType)simpleType).ifPresent(itemDsl -> {
                    ComponentIdentifier itemIdentifier = (ComponentIdentifier)ApplicationModelTypeUtils.getIdentifier(itemDsl).get();
                    List<ComponentAstBuilder> componentModels = paramComponent.childComponentsStream().filter(c -> c.getIdentifier().equals(itemIdentifier)).filter(valueComponentModel -> valueComponentModel.getRawParameters().containsKey("value")).peek(valueComponentModel -> {
                        valueComponentModel.withParameterizedModel(MetadataTypeModelAdapter.createSimpleWrapperTypeModelAdapter(simpleType, extensionModelHelper));
                        valueComponentModel.getGenerationInformation().withSyntax((DslElementSyntax)itemDsl);
                    }).collect(Collectors.toList());
                    componentModel.withParameter(paramModel, parameterGroupModel, new DefaultComponentParameterAst(componentModels, paramModel, parameterGroupModel, paramComponent.getMetadata(), DefaultComponentGenerationInformation.builder().withSyntax(paramDsl).build(), componentModel.getPropertiesResolver()), Optional.of(paramComponent.getIdentifier()));
                });
            }

            public void visitObject(ObjectType itemType) {
                paramDsl.getGeneric((MetadataType)itemType).ifPresent(itemDsl -> {
                    ComponentIdentifier itemIdentifier = (ComponentIdentifier)ApplicationModelTypeUtils.getIdentifier(itemDsl).get();
                    HashMap objectTypeByTypeId = new HashMap();
                    HashMap typesDslMap = new HashMap();
                    HashMap itemIdentifiers = new HashMap();
                    LOGGER.debug("getArrayItemTypeVisitor.visitObject: visiting itemType '{}'.", (Object)itemType);
                    extensionModelHelper.resolveSubTypes(itemType).entrySet().stream().forEach(entry -> MetadataTypeUtils.getTypeId((MetadataType)((MetadataType)entry.getKey())).ifPresent(subTypeTypeId -> {
                        typesDslMap.put(subTypeTypeId, entry.getValue());
                        objectTypeByTypeId.put(subTypeTypeId, entry.getKey());
                        ((Optional)entry.getValue()).ifPresent(dslElementSyntax -> ApplicationModelTypeUtils.getIdentifier(dslElementSyntax).ifPresent(subTypeIdentifier -> itemIdentifiers.put(subTypeIdentifier, subTypeTypeId)));
                    }));
                    MetadataTypeUtils.getTypeId((MetadataType)itemType).ifPresent(itemTypeId -> {
                        typesDslMap.putIfAbsent(itemTypeId, Optional.of(itemDsl));
                        objectTypeByTypeId.putIfAbsent(itemTypeId, itemType);
                        itemIdentifiers.putIfAbsent(itemIdentifier, itemTypeId);
                    });
                    LOGGER.debug("getArrayItemTypeVisitor.visitObject: itemIdentifiers: '{}'.", itemIdentifiers);
                    List<ComponentAstBuilder> componentModels = paramComponent.childComponentsStream().filter(c -> itemIdentifiers.containsKey(c.getIdentifier())).peek(itemComponent -> {
                        String typeId = (String)itemIdentifiers.get(itemComponent.getIdentifier());
                        ((Optional)typesDslMap.get(typeId)).ifPresent(subTypeDsl -> {
                            ParameterizedModel parameterizedModel = ApplicationModelTypeUtils.resolveParameterizedModel(extensionModelHelper, (MetadataType)objectTypeByTypeId.get(typeId), itemComponent.getIdentifier());
                            itemComponent.withParameterizedModel(parameterizedModel);
                            itemComponent.getGenerationInformation().withSyntax((DslElementSyntax)subTypeDsl);
                            Multimap nestedComponents = ApplicationModelTypeUtils.getNestedComponents(itemComponent);
                            parameterizedModel.getParameterGroupModels().forEach(nestedGroup -> nestedGroup.getParameterModels().forEach(nestedParameter -> ApplicationModelTypeUtils.enrichComponentModels(itemComponent, (Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)nestedComponents, this.recursiveAwareContainedElement(typesDslMap, (DslElementSyntax)subTypeDsl, (ParameterModel)nestedParameter), nestedParameter, nestedGroup, nestedParameter.getType(), extensionModelHelper)));
                        });
                    }).collect(Collectors.toList());
                    componentModel.withParameter(paramModel, parameterGroupModel, new DefaultComponentParameterAst(componentModels, paramModel, parameterGroupModel, paramComponent.getMetadata(), DefaultComponentGenerationInformation.builder().withSyntax(paramDsl).build(), componentModel.getPropertiesResolver()), Optional.of(paramComponent.getIdentifier()));
                });
            }

            private Optional<DslElementSyntax> recursiveAwareContainedElement(Map<String, Optional<DslElementSyntax>> typesDslMap, DslElementSyntax subTypeDsl, ParameterModel nestedParameter) {
                return subTypeDsl.getContainedElement(nestedParameter.getName()).map(innerElement -> MetadataTypeUtils.getTypeId((MetadataType)nestedParameter.getType()).flatMap(typeId -> {
                    if (typesDslMap.containsKey(typeId)) {
                        LOGGER.debug("getArrayItemTypeVisitor.recursiveAwareContainedElement: No entry for '{}' in typesDslMap, ignoring.", typeId);
                        return (Optional)typesDslMap.get(typeId);
                    }
                    return Optional.empty();
                }).map(referencedDslElement -> {
                    LOGGER.debug("getArrayItemTypeVisitor.recursiveAwareContainedElement: processing typeId {}", referencedDslElement);
                    DslElementSyntaxBuilder baseReferenced = DslElementSyntaxBuilder.create().withAttributeName(innerElement.getAttributeName()).withElementName(innerElement.getElementName()).withNamespace(innerElement.getPrefix(), innerElement.getNamespace()).requiresConfig(innerElement.requiresConfig()).supportsAttributeDeclaration(innerElement.supportsAttributeDeclaration()).supportsChildDeclaration(innerElement.supportsChildDeclaration()).supportsTopLevelDeclaration(innerElement.supportsTopLevelDeclaration()).asWrappedElement(innerElement.isWrapped());
                    referencedDslElement.getContainedElementsByName().entrySet().forEach(containedEntry -> baseReferenced.containing((String)containedEntry.getKey(), (DslElementSyntax)containedEntry.getValue()));
                    referencedDslElement.getGenerics().entrySet().forEach(genericEntry -> baseReferenced.withGeneric((MetadataType)genericEntry.getKey(), (DslElementSyntax)genericEntry.getValue()));
                    return baseReferenced.build();
                }).orElse((DslElementSyntax)innerElement));
            }
        };
    }

    private static ParameterizedModel resolveParameterizedModel(ExtensionModelHelper extensionModelHelper, MetadataType type, ComponentIdentifier identifier) {
        return extensionModelHelper.findComponentModel(identifier).map(compModel -> compModel).orElseGet(() -> MetadataTypeModelAdapter.createParameterizedTypeModelAdapter(type, extensionModelHelper));
    }

    private static Optional<ComponentIdentifier> getIdentifier(DslElementSyntax dsl) {
        return ApplicationModelTypeUtils.getIdentifier(dsl.getElementName(), dsl.getPrefix());
    }

    private static Optional<ComponentIdentifier> getIdentifier(String elementName, String prefix) {
        if (StringUtils.isNotBlank((CharSequence)elementName) && StringUtils.isNotBlank((CharSequence)prefix)) {
            return Optional.of(ComponentIdentifier.builder().name(elementName).namespace(prefix).build());
        }
        return Optional.empty();
    }

    protected static Optional<String> getInfrastructureParameterName(MetadataType fieldType) {
        return ExtensionMetadataTypeUtils.getId((MetadataType)fieldType).map(InfrastructureTypeMapping.getNameMap()::get);
    }

    private static /* synthetic */ DefaultComponentAstBuilder lambda$null$26(DefaultComponentAstBuilder entryComponent, DslElementSyntax genericValueDsl, ParameterModel valueParamModel, ImmutableParameterGroupModel keyMapEntryGroupModel, ExtensionModelHelper extensionModelHelper, DefaultComponentAstBuilder entryValueComponent) {
        ArrayListMultimap nested = ArrayListMultimap.create();
        nested.put((Object)entryValueComponent.getIdentifier(), (Object)entryValueComponent);
        ApplicationModelTypeUtils.enrichComponentModels(entryComponent, (Multimap<ComponentIdentifier, DefaultComponentAstBuilder>)nested, Optional.of(genericValueDsl), valueParamModel, (ParameterGroupModel)keyMapEntryGroupModel, valueParamModel.getType(), extensionModelHelper);
        return entryValueComponent;
    }

    private static /* synthetic */ void lambda$getNestedComponents$22(Multimap result, DefaultComponentAstBuilder nestedComponent) {
        result.put((Object)nestedComponent.getIdentifier(), (Object)nestedComponent);
    }
}

