/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.AtomicBooleanSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.AtomicIntegerSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.AtomicLongSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CaseInsensitiveHashMapSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CaseInsensitiveMapWrapperSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CharsetSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CollectionDataTypeKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CopyOnWriteCaseInsensitiveMapSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CursorIteratorProviderKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CursorStreamProviderKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.EventKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.ExternalizableKryo;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.FunctionDataTypeKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.ImmutableCaseInsensitiveHashMapSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.ImmutableMultiMapSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.InputStreamKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.IteratorKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.KryoInstanceFactory;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.MapDataTypeKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.MuleKryoSerializerSupport;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.MuleMessageKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.MultiMapKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.SerializableLazyValueSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.SimpleDataTypeKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.TypedValueKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.UnmodifiableMultiMapSerializer;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyListSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyMapSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptySetSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonListSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonMapSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonSetSerializer;
import de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import de.javakaffee.kryoserializers.cglib.CGLibProxySerializer;
import de.javakaffee.kryoserializers.guava.ArrayListMultimapSerializer;
import de.javakaffee.kryoserializers.guava.HashMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableListSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableSetSerializer;
import de.javakaffee.kryoserializers.guava.LinkedHashMultimapSerializer;
import de.javakaffee.kryoserializers.guava.LinkedListMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ReverseListSerializer;
import de.javakaffee.kryoserializers.guava.TreeMultimapSerializer;
import de.javakaffee.kryoserializers.guava.UnmodifiableNavigableSetSerializer;
import de.javakaffee.kryoserializers.jodatime.JodaDateTimeSerializer;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.SerializableLazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;
import org.mule.runtime.core.internal.event.DefaultEventBuilder;
import org.mule.runtime.core.internal.message.DefaultMessageBuilder;
import org.mule.runtime.core.internal.metadata.DefaultCollectionDataType;
import org.mule.runtime.core.internal.metadata.DefaultFunctionDataType;
import org.mule.runtime.core.internal.metadata.DefaultMapDataType;
import org.mule.runtime.core.internal.metadata.SimpleDataType;
import org.mule.runtime.core.internal.util.CopyOnWriteCaseInsensitiveMap;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public abstract class AbstractKryoInstanceFactory
implements KryoInstanceFactory {
    @Override
    public Kryo getInstance(MuleContext muleContext, Optional<ClassLoaderRepository> classLoaderRepository) throws Exception {
        ExternalizableKryo kryo = new ExternalizableKryo(this.getClassResolver(classLoaderRepository));
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        kryo.setClassLoader(muleContext.getExecutionClassLoader());
        this.addStandardSerializers(kryo);
        this.addMuleSerializers(kryo, muleContext);
        return kryo;
    }

    protected abstract ClassResolver getClassResolver(Optional<ClassLoaderRepository> var1);

    private void addMuleSerializers(Kryo kryo, MuleContext muleContext) throws Exception {
        kryo.register(TypedValue.class, this.initSerializer(new TypedValueKryoSerializer(), muleContext));
        kryo.register(DefaultMessageBuilder.getMessageImplementationClass(), this.initSerializer(new MuleMessageKryoSerializer(kryo), muleContext));
        kryo.register(DefaultEventBuilder.InternalEventImplementation.class, this.initSerializer(new EventKryoSerializer(kryo), muleContext));
        kryo.register(CopyOnWriteCaseInsensitiveMap.class, (Serializer)new CopyOnWriteCaseInsensitiveMapSerializer());
        kryo.register(CaseInsensitiveMapWrapper.class, (Serializer)new CaseInsensitiveMapWrapperSerializer());
        kryo.register(CaseInsensitiveHashMap.class, (Serializer)new CaseInsensitiveHashMapSerializer());
        ImmutableCaseInsensitiveHashMapSerializer.registerSerializers(kryo);
        kryo.register(SimpleDataType.class, new SimpleDataTypeKryoSerializer());
        kryo.register(DefaultCollectionDataType.class, (Serializer)new CollectionDataTypeKryoSerializer());
        kryo.register(DefaultMapDataType.class, (Serializer)new MapDataTypeKryoSerializer());
        kryo.register(DefaultFunctionDataType.class, (Serializer)new FunctionDataTypeKryoSerializer());
        kryo.register(MultiMap.class, (Serializer)new MultiMapKryoSerializer());
        ImmutableMultiMapSerializer.registerSerializers(kryo);
        UnmodifiableMultiMapSerializer.registerSerializers(kryo);
        kryo.register(Iterator.class, (Serializer)new IteratorKryoSerializer());
        kryo.register(CursorIteratorProvider.class, (Serializer)new CursorIteratorProviderKryoSerializer());
        kryo.register(InputStream.class, (Serializer)new InputStreamKryoSerializer());
        kryo.register(CursorStreamProvider.class, (Serializer)new CursorStreamProviderKryoSerializer());
    }

    private <T> MuleKryoSerializerSupport<T> initSerializer(MuleKryoSerializerSupport<T> serializer, MuleContext muleContext) throws Exception {
        LifecycleUtils.initialiseIfNeeded(serializer, (MuleContext)muleContext);
        return serializer;
    }

    private void addStandardSerializers(Kryo kryo) {
        kryo.register(Arrays.asList("").getClass(), (Serializer)new ArraysAsListSerializer());
        kryo.register(Collections.EMPTY_LIST.getClass(), (Serializer)new CollectionsEmptyListSerializer());
        kryo.register(Collections.EMPTY_MAP.getClass(), (Serializer)new CollectionsEmptyMapSerializer());
        kryo.register(Collections.EMPTY_SET.getClass(), (Serializer)new CollectionsEmptySetSerializer());
        kryo.register(Collections.singletonList("").getClass(), (Serializer)new CollectionsSingletonListSerializer());
        kryo.register(Collections.singleton("").getClass(), (Serializer)new CollectionsSingletonSetSerializer());
        kryo.register(Collections.singletonMap("", "").getClass(), (Serializer)new CollectionsSingletonMapSerializer());
        kryo.register(GregorianCalendar.class, (Serializer)new GregorianCalendarSerializer());
        kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer());
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
        SynchronizedCollectionsSerializer.registerSerializers(kryo);
        kryo.register(CGLibProxySerializer.CGLibProxyMarker.class, (Serializer)new CGLibProxySerializer());
        kryo.register(DateTime.class, (Serializer)new JodaDateTimeSerializer());
        kryo.register(AtomicLong.class, (Serializer)new AtomicLongSerializer());
        kryo.register(AtomicInteger.class, (Serializer)new AtomicIntegerSerializer());
        kryo.register(AtomicBooleanSerializer.class, (Serializer)new AtomicBooleanSerializer());
        CharsetSerializer.register(kryo);
        kryo.register(SerializableLazyValue.class, (Serializer)new SerializableLazyValueSerializer());
        ImmutableListSerializer.registerSerializers((Kryo)kryo);
        ImmutableSetSerializer.registerSerializers((Kryo)kryo);
        ImmutableMapSerializer.registerSerializers((Kryo)kryo);
        ImmutableMultimapSerializer.registerSerializers((Kryo)kryo);
        ReverseListSerializer.registerSerializers((Kryo)kryo);
        UnmodifiableNavigableSetSerializer.registerSerializers((Kryo)kryo);
        ArrayListMultimapSerializer.registerSerializers((Kryo)kryo);
        HashMultimapSerializer.registerSerializers((Kryo)kryo);
        LinkedHashMultimapSerializer.registerSerializers((Kryo)kryo);
        LinkedListMultimapSerializer.registerSerializers((Kryo)kryo);
        TreeMultimapSerializer.registerSerializers((Kryo)kryo);
    }
}

