/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.management.stats;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.mule.runtime.core.api.management.stats.FlowsSummaryStatistics;

public class DefaultFlowsSummaryStatistics
implements FlowsSummaryStatistics {
    private static final String APIKIT_FLOWNAME_REGEX = "(\\w*):(\\\\[^:]*)(:[^:]*)?:([^\\/\\\\\\[\\\\\\]\\{\\}#]*)";
    private static final String APIKIT_SOAP_FLOWNAME_REGEX = "(\\w*):\\\\([^\\/\\\\\\[\\\\\\]\\{\\}#]*)";
    private static final Pattern APIKIT_FLOWNAME_PATTERN = Pattern.compile("(\\w*):(\\\\[^:]*)(:[^:]*)?:([^\\/\\\\\\[\\\\\\]\\{\\}#]*)");
    private static final Pattern APIKIT_SOAP_FLOWNAME_PATTERN = Pattern.compile("(\\w*):\\\\([^\\/\\\\\\[\\\\\\]\\{\\}#]*)");
    private static final long serialVersionUID = 1L;
    private final boolean enabled;
    private final AtomicInteger declaredPrivateFlows = new AtomicInteger(0);
    private final AtomicInteger activePrivateFlows = new AtomicInteger(0);
    private final AtomicInteger declaredTriggerFlows = new AtomicInteger(0);
    private final AtomicInteger activeTriggerFlows = new AtomicInteger(0);

    public DefaultFlowsSummaryStatistics(boolean isStatisticsEnabled) {
        this.enabled = isStatisticsEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public int incrementDeclaredPrivateFlow() {
        return this.declaredPrivateFlows.incrementAndGet();
    }

    public int incrementActivePrivateFlow() {
        return this.activePrivateFlows.incrementAndGet();
    }

    public int incrementDeclaredTriggerFlow() {
        return this.declaredTriggerFlows.incrementAndGet();
    }

    public int incrementActiveTriggerFlow() {
        return this.activeTriggerFlows.incrementAndGet();
    }

    public int decrementActiveTriggerFlow() {
        return this.activeTriggerFlows.decrementAndGet();
    }

    public int decrementActivePrivateFlow() {
        return this.activePrivateFlows.decrementAndGet();
    }

    public int decrementDeclaredPrivateFlow() {
        return this.declaredPrivateFlows.decrementAndGet();
    }

    public int decrementDeclaredTriggerFlow() {
        return this.declaredTriggerFlows.decrementAndGet();
    }

    @Override
    public int getDeclaredPrivateFlows() {
        return this.declaredPrivateFlows.get();
    }

    @Override
    public int getActivePrivateFlows() {
        return this.activePrivateFlows.get();
    }

    @Override
    public int getDeclaredTriggerFlows() {
        return this.declaredTriggerFlows.get();
    }

    @Override
    public int getActiveTriggerFlows() {
        return this.activeTriggerFlows.get();
    }

    public static boolean isApiKitFlow(String flowName) {
        return APIKIT_FLOWNAME_PATTERN.matcher(flowName).matches() || APIKIT_SOAP_FLOWNAME_PATTERN.matcher(flowName).matches();
    }
}

