/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.buffer;

import com.google.common.collect.Multimap;
import com.mulesoft.mule.runtime.module.batch.api.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.notification.BatchNotification;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchStepAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.engine.BatchProcessingTemplate;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.InMemoryRecordBuffer;
import com.mulesoft.mule.runtime.module.batch.reporting.StepExceptionReporter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AggregatorRecordBuffer
extends InMemoryRecordBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregatorRecordBuffer.class);
    private final Processor chain;
    private final ComponentLocation location;
    protected final MuleContext muleContext;
    protected final BatchEngine batchEngine;
    protected final BatchStepAdapter step;
    protected StepExceptionReporter exceptionReporter;
    protected final NotificationDispatcher notificationDispatcher;

    public AggregatorRecordBuffer(String name, int size, BatchEngine batchEngine, BatchStepAdapter step, Processor chain, ComponentLocation location, NotificationDispatcher notificationDispatcher, MuleContext muleContext) {
        super(name, size);
        this.chain = chain;
        this.location = location;
        this.notificationDispatcher = notificationDispatcher;
        this.muleContext = muleContext;
        this.batchEngine = batchEngine;
        this.step = step;
    }

    @Override
    protected void doFlush(BatchJobInstanceAdapter jobInstance, Multimap<BatchTransactionContext, Record> records) {
        CoreEvent event;
        CompletableFuture<Void> completion;
        block6: {
            this.notificationDispatcher.dispatch((Notification)new BatchNotification((BatchJobInstance)jobInstance, this.step, BatchNotification.STEP_AGGREGATOR_START));
            completion = new CompletableFuture<Void>();
            event = this.batchEngine.createEventBuilder(null, jobInstance, completion).build();
            event = this.configureChainEvent(event, jobInstance, records);
            if (event != null) break block6;
            records.values().forEach(r -> r.getCompletionCallback().decrementConsumers());
            completion.complete(null);
            return;
        }
        try {
            try {
                this.makeProcessingTemplate(records, this.chain, this.muleContext).process(jobInstance, event);
            }
            catch (Exception e) {
                if (e.getCause() instanceof InterruptedException) {
                    throw new MuleRuntimeException(e.getCause());
                }
                LOGGER.error(String.format("Exception found flushing %d records on buffer %s", records.size(), this.getName()), (Throwable)e);
                records.values().forEach(r -> r.getCompletionCallback().decrementConsumers());
                completion.complete(null);
            }
        }
        catch (Throwable throwable) {
            records.values().forEach(r -> r.getCompletionCallback().decrementConsumers());
            completion.complete(null);
            throw throwable;
        }
        records.values().forEach(r -> r.getCompletionCallback().decrementConsumers());
        completion.complete(null);
    }

    protected abstract CoreEvent configureChainEvent(CoreEvent var1, BatchJobInstanceAdapter var2, Multimap<BatchTransactionContext, Record> var3) throws MuleException;

    protected abstract BatchProcessingTemplate makeProcessingTemplate(Multimap<BatchTransactionContext, Record> var1, Processor var2, MuleContext var3);

    protected void markError(BatchJobInstanceAdapter jobInstance, List<Record> records, Exception e) {
        this.exceptionReporter.report(jobInstance, e);
        for (Record record : records) {
            record.markAsFailedInStep(this.step, e);
        }
        this.notificationDispatcher.dispatch((Notification)new BatchNotification((BatchJobInstance)jobInstance, (BatchStep)this.step, e, BatchNotification.STEP_AGGREGATOR_FAILED));
    }

    public void setExceptionReporter(StepExceptionReporter exceptionReporter) {
        this.exceptionReporter = exceptionReporter;
    }

    protected ComponentLocation getLocation() {
        return this.location;
    }
}

