/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.InnerUsesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.TypesResolvedAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.PassThroughTypeResolver;
import org.mule.runtime.api.component.location.ComponentLocation;

public class AggregatorListenerTypeResolver
extends PassThroughTypeResolver {
    public static final String PARAMETER_AGGREGATOR_REF = "aggregatorName";

    private void ensureMuleFlowNodeTypesResolved(MuleFlowNode muleFlowNode, MuleApplicationNode muleApplicationNode, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        Optional typesResolvedAnnotation = muleFlowNode.getAnnotation(TypesResolvedAnnotation.class);
        if (!typesResolvedAnnotation.isPresent()) {
            typingMuleAstVisitor.resolveType(muleFlowNode, TypeUtils.createEventType(null), visitorContext.getAstNotification(), muleApplicationNode);
        }
    }

    private void ensureComponentLocationTypesResolved(MuleApplicationNode muleApplicationNode, ComponentLocation componentLocation, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        String rootContainerName = componentLocation.getRootContainerName();
        muleApplicationNode.findMuleFlowNode(rootContainerName).ifPresent(muleFlowNode -> this.ensureMuleFlowNodeTypesResolved((MuleFlowNode)muleFlowNode, muleApplicationNode, typingMuleAstVisitor, visitorContext));
    }

    private Optional<MessageProcessorNode> findAggregatorMessageProcessorNode(String aggregatorRef, MuleApplicationNode muleApplicationNode, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        Optional<MessageProcessorNode> messageProcessorNodeOptional = muleApplicationNode.findMessageProcessorNodeByName(aggregatorRef);
        if (messageProcessorNodeOptional.isPresent()) {
            MessageProcessorNode messageProcessorNode = messageProcessorNodeOptional.get();
            ComponentLocation componentLocation = messageProcessorNode.getComponentModel().getLocation();
            this.ensureComponentLocationTypesResolved(muleApplicationNode, componentLocation, typingMuleAstVisitor, visitorContext);
        }
        return messageProcessorNodeOptional;
    }

    private Optional<EventType> resolveAggregatorEventType(String aggregatorRef, MuleApplicationNode muleApplicationNode, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        if (aggregatorRef == null) {
            return Optional.empty();
        }
        return this.findAggregatorMessageProcessorNode(aggregatorRef, muleApplicationNode, typingMuleAstVisitor, visitorContext).flatMap(aggregatorMessageProcessorNode -> aggregatorMessageProcessorNode.getAnnotation(InnerUsesTypeAnnotation.class)).map(InnerUsesTypeAnnotation::getUsesEventType);
    }

    private EventType resolveEventType(MessageProcessorNode messageProcessorNode, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        MuleApplicationNode muleApplicationNode = visitorContext.getAnnotation(MuleApplicationAnnotation.class).map(MuleApplicationAnnotation::getMuleApplicationNode).orElse(null);
        if (muleApplicationNode == null) {
            return new EventType();
        }
        return Optional.ofNullable(messageProcessorNode.getComponentModel()).flatMap(componentModel -> this.resolveAggregatorEventType((String)componentModel.getParameter("General", PARAMETER_AGGREGATOR_REF).getValue().getRight(), muleApplicationNode, typingMuleAstVisitor, visitorContext)).orElse(new EventType());
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        EventType eventType = this.resolveEventType(messageProcessorNode, typingMuleAstVisitor, visitorContext);
        messageProcessorNode.annotate(new DefinesTypeAnnotation(eventType));
        return eventType;
    }

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_SOURCE_NODE);
    }
}

