/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.EnterpriseLicenseKeyRequest;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManager;
import com.mulesoft.licm.MuleStudioEmbeddedLicenseKey;
import com.mulesoft.licm.MuleStudioEmbeddedLicenseKeyRequest;
import com.mulesoft.licm.MuleStudioEmbeddedLicenseManager;

public class LicenseManagementFactory {
    private static LicenseManagementFactory instance = null;
    public static final String MULE_EE = "mule-ee";

    public static synchronized LicenseManagementFactory getInstance() {
        if (instance == null) {
            instance = new LicenseManagementFactory();
        }
        return instance;
    }

    public LicenseManager createLicenseManager(String licenseManagerType) throws LicenseKeyException {
        if (MULE_EE.equalsIgnoreCase(licenseManagerType)) {
            return new MuleStudioEmbeddedLicenseManager();
        }
        throw new IllegalArgumentException("Invalid license manager type: \"" + licenseManagerType + "\"");
    }

    public EnterpriseLicenseKeyRequest createLicenseRequest(String licenseRequestType) throws LicenseKeyException {
        if (licenseRequestType == null) {
            throw new IllegalArgumentException("Missing license key request type!");
        }
        MuleStudioEmbeddedLicenseKeyRequest request = new MuleStudioEmbeddedLicenseKeyRequest();
        request.setProduct(licenseRequestType);
        return request;
    }

    public EnterpriseLicenseKey createLicenseKey(String licenseKeyType) throws LicenseKeyException {
        if (licenseKeyType == null) {
            throw new IllegalArgumentException("Missing license key type!");
        }
        MuleStudioEmbeddedLicenseKey key = null;
        if (!licenseKeyType.equalsIgnoreCase(MULE_EE)) {
            throw new LicenseKeyException("Unrecognized type!");
        }
        key = new MuleStudioEmbeddedLicenseKey();
        return key;
    }
}

