/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.lock;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.mulesoft.mule.runtime.module.cluster.internal.lock.HazelcastLock;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.MapNameNormalizer;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.core.internal.lock.LockProvider;

public class HazelcastLockProvider
implements LockProvider {
    private static final String LOCKS_MAP_SUFFIX = "_locks_map";
    private final String clusterId;
    private HazelcastInstance hazelcastInstance;
    private String appName;

    public HazelcastLockProvider(String clusterId, HazelcastInstance hazelcastInstance, String appName) {
        this.clusterId = clusterId;
        this.hazelcastInstance = hazelcastInstance;
        this.appName = appName;
    }

    public Lock createLock(String lockId) {
        IMap locksMap = this.hazelcastInstance.getMap(String.valueOf(this.getNormalizedMapName(String.valueOf(this.clusterId) + "_" + this.appName)) + LOCKS_MAP_SUFFIX);
        return new HazelcastLock(locksMap, String.valueOf(this.getNormalizedMapName(String.valueOf(this.clusterId) + "_" + this.appName)) + "_" + lockId);
    }

    private String getNormalizedMapName(String mapName) {
        return MapNameNormalizer.normalize(mapName);
    }
}

