/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.artifact.ast;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.artifact.ast.ComponentGenerationInformation;
import org.mule.tooling.client.api.artifact.ast.ComponentParameterAst;
import org.mule.tooling.client.api.component.ComponentIdentifier;
import org.mule.tooling.client.api.component.ComponentType;
import org.mule.tooling.client.api.component.location.ComponentLocation;
import org.mule.tooling.client.api.component.location.SourceCodeLocation;
import org.mule.tooling.client.api.extension.model.ExtensionModel;

public class ComponentAst {
    private final String componentId;
    private final ComponentType componentType;
    private final ExtensionModel extension;
    private final ComponentGenerationInformation generationInformation;
    private final ComponentIdentifier identifier;
    private final ComponentLocation location;
    private final SourceCodeLocation metadata;
    private final Object model;
    private final MetadataType type;
    private final List<ComponentParameterAst> parameters;
    private final Map<String, ComponentParameterAst> parametersMap;
    private final List<ComponentAst> directChildren;

    public ComponentAst(String componentId, ComponentType componentType, ExtensionModel extension, ComponentGenerationInformation generationInformation, ComponentIdentifier identifier, ComponentLocation location, SourceCodeLocation metadata, Object model, MetadataType type, List<ComponentParameterAst> parameters, List<ComponentAst> directChildren) {
        this.componentId = componentId;
        this.componentType = componentType;
        this.extension = extension;
        this.generationInformation = generationInformation;
        this.identifier = identifier;
        this.location = location;
        this.metadata = metadata;
        this.model = model;
        this.type = type;
        this.parameters = Collections.unmodifiableList(parameters);
        this.parametersMap = parameters.stream().filter(p -> p.getModel() != null).collect(Collectors.toMap(p -> p.getModel().getName(), UnaryOperator.identity()));
        this.directChildren = Collections.unmodifiableList(directChildren);
    }

    public ComponentIdentifier getIdentifier() {
        return this.identifier;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public ComponentLocation getLocation() {
        return this.location;
    }

    public SourceCodeLocation getMetadata() {
        return this.metadata;
    }

    public ComponentGenerationInformation getGenerationInformation() {
        return this.generationInformation;
    }

    public Optional<String> getComponentId() {
        return Optional.ofNullable(this.componentId);
    }

    public ExtensionModel getExtension() {
        return this.extension;
    }

    public <M> Optional<M> getModel(Class<M> modelClass) {
        if (modelClass.isInstance(this.model)) {
            return Optional.ofNullable(this.model);
        }
        return Optional.empty();
    }

    public MetadataType getType() {
        return this.type;
    }

    public ComponentParameterAst getParameter(String paramName) {
        return this.getAllParameters().stream().filter(p -> p.getModel() != null && p.getModel().getName().equals(paramName)).findAny().orElse(null);
    }

    public List<ComponentParameterAst> getAllParameters() {
        return this.parameters;
    }

    public Map<String, ComponentParameterAst> getParameters() {
        return this.parametersMap;
    }

    public List<ComponentAst> getDirectChildren() {
        return this.directChildren;
    }
}

