/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.client.exception.RecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientConnectionListener;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientProvider;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.client.session.factory.FileSystemApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PollerPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PrimaryPollerPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis.ApisFileSystemPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis.ApisPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis.ApisPollerPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis.DisabledApisPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis.GatewayApisPoller;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTracker;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.RetriableApiTracker;
import com.mulesoft.mule.runtime.gw.retry.BackoffRunnableRetrierFactory;
import java.io.File;

public class ApisPlatformInteractionLifecycleFactory {
    public ApisPlatformInteractionLifecycle create(GatewayConfiguration configuration, boolean standalone, ApiService apiService, ApiTrackingService apiTrackingService, ApiPlatformClientProvider clientProvider, ApiPlatformSessionFactory restPlatformSessionFactory, BackoffSchedulerFactory schedulerFactory, BackoffConfigurationSupplier configurationSupplier, BackoffRunnableRetrierFactory backoffRunnableRetrierFactory) {
        switch (configuration.platformServices().apisInfoSource()) {
            case POLLING: {
                if (!configuration.platformClient().isOfflineModeEnabled()) {
                    return this.polling(configuration, standalone, apiService, apiTrackingService, clientProvider, restPlatformSessionFactory, schedulerFactory, configurationSupplier, backoffRunnableRetrierFactory);
                }
                return new DisabledApisPlatformInteractionLifecycle();
            }
            case FILE_SYSTEM: {
                return this.fileSystem(configuration, apiService, apiTrackingService);
            }
        }
        return new DisabledApisPlatformInteractionLifecycle();
    }

    private ApisPlatformInteractionLifecycle fileSystem(GatewayConfiguration configuration, ApiService apiService, ApiTrackingService apiTrackingService) {
        FileSystemApiPlatformSessionFactory sessionFactory = new FileSystemApiPlatformSessionFactory((File)configuration.platformServices().apisFolder().get());
        ApiTracker apiTracker = new ApiTracker(apiTrackingService, (ApiPlatformSessionFactory)sessionFactory);
        return new ApisFileSystemPlatformInteractionLifecycle(apiService, apiTracker);
    }

    private ApisPlatformInteractionLifecycle polling(GatewayConfiguration configuration, boolean standalone, ApiService apiService, ApiTrackingService apiTrackingService, ApiPlatformClientProvider clientProvider, ApiPlatformSessionFactory restPlatformSessionFactory, BackoffSchedulerFactory schedulerFactory, BackoffConfigurationSupplier configurationSupplier, BackoffRunnableRetrierFactory backoffRunnableRetrierFactory) {
        RetriableApiTracker apiTracker = new RetriableApiTracker(new ApiTracker(apiTrackingService, restPlatformSessionFactory, RecoverableExceptionMessageLogger::new), (RunnableRetrier<ApiKey>)backoffRunnableRetrierFactory.apiTrackerRetrier());
        GatewayApisPoller poller = new GatewayApisPoller(configuration, apiTrackingService, restPlatformSessionFactory, schedulerFactory, configurationSupplier);
        PollerPlatformInteractionLifecycle pollerLifecycle = new PollerPlatformInteractionLifecycle(poller);
        PrimaryPollerPlatformInteractionLifecycle primaryLifecycle = new PrimaryPollerPlatformInteractionLifecycle(pollerLifecycle, standalone);
        ApisPollerPlatformInteractionLifecycle lifecycle = new ApisPollerPlatformInteractionLifecycle(primaryLifecycle, apiService, apiTracker);
        clientProvider.addConnectionListener((ApiPlatformClientConnectionListener)lifecycle);
        return lifecycle;
    }
}

