/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.replication;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.deployment.replication.DistributedApiConfigurationEntry;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.module.cluster.api.map.EntryEvent;
import com.mulesoft.mule.runtime.module.cluster.api.map.EntryListener;
import org.slf4j.Logger;

public class DistributedPoliciesMapEntryListener
implements EntryListener<String, DistributedApiConfigurationEntry> {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(DistributedPoliciesMapEntryListener.class);
    private final ApiService apiService;
    private final ApiTrackingService apiTrackingService;
    private final PolicySetDeploymentService policySetDeploymentService;
    private final ContractSnapshots contractSnapshots;
    private final boolean clusterIsClientMode;

    public DistributedPoliciesMapEntryListener(ApiService apiService, ApiTrackingService apiTrackingService, PolicySetDeploymentService policySetDeploymentService, ContractSnapshots contractSnapshots, boolean clusterIsClientMode) {
        this.apiService = apiService;
        this.apiTrackingService = apiTrackingService;
        this.policySetDeploymentService = policySetDeploymentService;
        this.contractSnapshots = contractSnapshots;
        this.clusterIsClientMode = clusterIsClientMode;
    }

    public void entryAdded(EntryEvent<String, DistributedApiConfigurationEntry> entry) {
        this.ifDebug(() -> LOGGER.debug("Policies map entry added [{}] by {} [hashCode={}]", new Object[]{this.getApiKey(entry), entry.getAddressAsString(), this.getConfigEntry(entry).hashCode()}));
        if (this.clusterIsClientMode || !entry.isLocalMember()) {
            this.ifDebug(() -> LOGGER.debug("Storing map entry [{}] into map store as a backup", (Object)this.getApiKey(entry)));
            this.handleEntry(entry);
        }
    }

    public void entryUpdated(EntryEvent<String, DistributedApiConfigurationEntry> entry) {
        this.ifDebug(() -> LOGGER.debug("Policies map entry updated [{}] by {} [hashCode={}]", new Object[]{this.getApiKey(entry), entry.getAddressAsString(), this.getConfigEntry(entry).hashCode()}));
        if (this.clusterIsClientMode || !entry.isLocalMember()) {
            this.ifDebug(() -> LOGGER.debug("Updating map entry [{}] into map store as a backup", (Object)this.getApiKey(entry)));
            this.handleEntry(entry);
        }
    }

    public void entryRemoved(EntryEvent<String, DistributedApiConfigurationEntry> entry) {
        this.ifDebug(() -> LOGGER.debug("Policies map entry removed [{}].", (Object)this.getApiKey(entry)));
        if (this.clusterIsClientMode || !entry.isLocalMember()) {
            this.ifDebug(() -> LOGGER.debug("Removing map entry [{}] as the requester is not us.", (Object)this.getApiKey(entry)));
            this.apiTrackingService.apiUntracked(this.getApiKey(entry));
        } else {
            this.ifDebug(() -> LOGGER.debug("Local member fired the removal of [{}].", (Object)this.getApiKey(entry)));
        }
    }

    private ApiKey getApiKey(EntryEvent<String, DistributedApiConfigurationEntry> entry) {
        return new ApiKey(Long.valueOf(Long.parseLong((String)entry.getKey())));
    }

    private DistributedApiConfigurationEntry getConfigEntry(EntryEvent<String, DistributedApiConfigurationEntry> entry) {
        return (DistributedApiConfigurationEntry)entry.getValue();
    }

    private void handleEntry(EntryEvent<String, DistributedApiConfigurationEntry> entry) {
        if (this.apiService.isDeployed(this.getApiKey(entry))) {
            this.policySetDeploymentService.policiesForApi(this.getApiKey(entry), this.getConfigEntry(entry).getPolicySet());
            this.contractSnapshots.slas(this.getApiKey(entry), this.getConfigEntry(entry).getSlas());
        } else {
            this.policySetDeploymentService.conciliatePolicies(this.getApiKey(entry), this.getConfigEntry(entry).getPolicySet().getPolicyDefinitions());
        }
    }

    private void ifDebug(Runnable closure) {
        if (LOGGER.isDebugEnabled()) {
            closure.run();
        }
    }
}

