/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.tracking;

import com.mulesoft.mule.runtime.gw.api.config.OnApiDeletedConfiguration;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.service.ContractService;
import com.mulesoft.mule.runtime.gw.client.dto.PlatformContractAdapter;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.deployment.replication.ApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.NoTrackingInfo;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class DefaultApiTrackingService
implements ApiTrackingService {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(DefaultApiTrackingService.class);
    private final ApiService apiService;
    private final PolicySetDeploymentService policySetDeploymentService;
    private final ApiConfigurationCache apiConfigurationCache;
    private final ContractSnapshots contractSnapshots;
    private final ContractService contractService;
    private final OnApiDeletedConfiguration onApiDeletedConfiguration;

    public DefaultApiTrackingService(ApiService apiService, PolicySetDeploymentService policySetDeploymentService, ApiConfigurationCache apiConfigurationCache, ContractSnapshots contractSnapshots, ContractService contractService, OnApiDeletedConfiguration onApiDeletedConfiguration) {
        this.apiService = apiService;
        this.policySetDeploymentService = policySetDeploymentService;
        this.apiConfigurationCache = apiConfigurationCache;
        this.contractSnapshots = contractSnapshots;
        this.contractService = contractService;
        this.onApiDeletedConfiguration = onApiDeletedConfiguration;
    }

    @Override
    public void apiTracked(ApiKey apiKey, TrackingInfo trackingInfo, PolicySet policySet, List<Sla> slas) {
        this.apiService.get(apiKey).ifPresent(api -> {
            api.updateTrackingInfo(trackingInfo);
            api.getImplementation().gatekeeperStatus().tracked();
        });
        this.apiConfigurationCache.set(apiKey, policySet, slas);
        this.policySetDeploymentService.policiesForApi(apiKey, policySet);
        this.contractSnapshots.slas(apiKey, slas);
    }

    @Override
    public void apiUntracked(ApiKey apiKey) {
        if (this.onApiDeletedConfiguration.shouldBlock()) {
            LOGGER.debug("API {} is not tracked anymore, it will be blocked.", (Object)apiKey);
            this.apiConfigurationCache.remove(apiKey);
            this.policySetDeploymentService.removeAll(apiKey);
        } else {
            LOGGER.debug("API {} is not tracked anymore, current policies will be kept.", (Object)apiKey);
            this.apiConfigurationCache.getPolicies(apiKey).ifPresent(policySet -> this.policySetDeploymentService.policiesForApi(apiKey, policySet));
        }
        this.apiService.get(apiKey).ifPresent(api -> {
            api.updateTrackingInfo((TrackingInfo)NoTrackingInfo.untracked());
            api.getImplementation().gatekeeperStatus().untracked();
        });
    }

    @Override
    public void apiTrackingFailed(ApiKey apiKey) {
        this.apiService.get(apiKey).ifPresent(api -> {
            if (!api.getTrackingInfo().isFailedTracking()) {
                LOGGER.debug("Marking API tracking for {} as failed", (Object)apiKey);
                api.updateTrackingInfo((TrackingInfo)NoTrackingInfo.trackingFailed());
                this.apiConfigurationCache.getPolicies(apiKey).ifPresent(policySet -> this.policySetDeploymentService.policiesForApi(apiKey, policySet));
            }
        });
    }

    @Override
    public List<Api> getTrackedApis() {
        return this.apiService.getApis().stream().filter(this::isTracked).collect(Collectors.toList());
    }

    @Override
    public List<Api> getFailedTrackingApis() {
        return this.apiService.getApis().stream().filter(api -> api.getTrackingInfo().isFailedTracking()).collect(Collectors.toList());
    }

    @Override
    public List<Api> getTrackedApisRequiringContracts() {
        return this.apiService.getApis().stream().filter(api -> this.isTracked((Api)api) && this.requiresContracts((Api)api)).collect(Collectors.toList());
    }

    @Override
    public void clientsPolling(ApiKey apiKey, List<PlatformContractAdapter> contracts, String contractsEntityTag) {
        this.apiService.get(apiKey).ifPresent(api -> api.updateContractsTrackingInfo(contractsEntityTag));
        this.contractSnapshots.clients(apiKey, contracts);
    }

    private boolean isTracked(Api api) {
        return api.getTrackingInfo().isTracked();
    }

    private boolean requiresContracts(Api api) {
        return this.contractService.trackedApis().contains(api.getKey());
    }
}

