/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;

public final class MuleHazelcastInstanceFactory {
    private MuleHazelcastInstanceFactory() {
    }

    public static HazelcastInstance newHazelcastInstance(Config config) {
        ClassLoader creationClassLoader = config.getClassLoader();
        ClassLoader outerClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (creationClassLoader != null && creationClassLoader != outerClassLoader) {
                Thread.currentThread().setContextClassLoader(creationClassLoader);
            }
            HazelcastInstance hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
            return hazelcastInstance;
        }
        finally {
            if (creationClassLoader != null && creationClassLoader != outerClassLoader) {
                Thread.currentThread().setContextClassLoader(outerClassLoader);
            }
        }
    }
}

