/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment;

import com.mulesoft.mule.runtime.gw.api.analytics.DeploymentType;

public class DeploymentTarget {
    private static final String POD_NAME = "POD_NAME";
    private static final String RTF_ID = "RTF_ID";
    private static final String MULE_AGENT_CONFIGURATION_FOLDER = "mule.agent.configuration.folder";

    public static boolean isCloudHub() {
        try {
            Class.forName("com.mulesoft.mule.runtime.gw.cloudhub.GatewayInCloudHub");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static boolean isRuntimeFabric() {
        return System.getenv(POD_NAME) != null && System.getenv(RTF_ID) != null;
    }

    public static boolean isHybrid() {
        return System.getProperty(MULE_AGENT_CONFIGURATION_FOLDER) != null;
    }

    public static DeploymentType getDeploymentTarget() {
        if (DeploymentTarget.isCloudHub()) {
            return DeploymentType.CH;
        }
        if (DeploymentTarget.isRuntimeFabric()) {
            return DeploymentType.RF;
        }
        if (DeploymentTarget.isHybrid()) {
            return DeploymentType.HY;
        }
        return DeploymentType.SA;
    }
}

