/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model.contracts;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.config.GatewaySecurityConfiguration;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypterFactory;
import com.mulesoft.mule.runtime.gw.model.contracts.PersistentApiContracts;
import com.mulesoft.mule.runtime.gw.model.contracts.StandaloneApiContracts;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.CompactContractsRepository;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.EncryptedContractsRepository;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.MapDBContractRepository;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.NotEncryptedContractRepository;
import com.mulesoft.mule.runtime.gw.notification.ApiContractsListener;
import java.util.List;

public class ApiContractsFactory {
    public static ApiContracts create(ApiKey apiKey, List<ApiContractsListener> listeners) {
        return new PersistentApiContracts(apiKey, new StandaloneApiContracts(apiKey, listeners), ApiContractsFactory.repository());
    }

    private static ContractRepository repository() {
        return ApiContractsFactory.useEncryptedRepository() ? new CompactContractsRepository(new EncryptedContractsRepository(new MapDBContractRepository(), RuntimeEncrypterFactory.createDefaultRuntimeEncrypter())) : new NotEncryptedContractRepository(new MapDBContractRepository(), RuntimeEncrypterFactory.createDefaultRuntimeEncrypter());
    }

    private static boolean useEncryptedRepository() {
        GatewaySecurityConfiguration securityConfiguration = new GatewaySecurityConfiguration();
        return securityConfiguration.isEncryptionEnabled() && !securityConfiguration.hashClients();
    }
}

