/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine;

import com.mulesoft.mule.runtime.module.batch.internal.kryo.BatchEventSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.api.serialization.SerializationProtocol;

public class LegacyAwareObjectSerializerWrapper
implements ObjectSerializer {
    private final SerializationProtocol internalProtocol;
    private final SerializationProtocol externalProtocol;

    public LegacyAwareObjectSerializerWrapper(ObjectSerializer serializer) {
        this.internalProtocol = new SerializationProtocolWrapper(serializer.getInternalProtocol());
        this.externalProtocol = new SerializationProtocolWrapper(serializer.getExternalProtocol());
    }

    public SerializationProtocol getInternalProtocol() {
        return this.internalProtocol;
    }

    public SerializationProtocol getExternalProtocol() {
        return this.externalProtocol;
    }

    private static class SerializationProtocolWrapper
    implements SerializationProtocol {
        private final SerializationProtocol protocol;

        public SerializationProtocolWrapper(SerializationProtocol protocol) {
            this.protocol = protocol;
        }

        public byte[] serialize(Object o) throws SerializationException {
            return this.protocol.serialize(o);
        }

        public void serialize(Object o, OutputStream outputStream) throws SerializationException {
            this.protocol.serialize(o, outputStream);
        }

        public <T> T deserialize(byte[] bytes) throws SerializationException {
            try {
                return (T)this.protocol.deserialize(bytes);
            }
            catch (SerializationException e) {
                return (T)this.executeIndicatingLegacySerialization(e, () -> this.protocol.deserialize(bytes));
            }
        }

        public <T> T deserialize(byte[] bytes, ClassLoader classLoader) throws SerializationException {
            try {
                return (T)this.protocol.deserialize(bytes, classLoader);
            }
            catch (SerializationException e) {
                return (T)this.executeIndicatingLegacySerialization(e, () -> this.protocol.deserialize(bytes, classLoader));
            }
        }

        public <T> T deserialize(InputStream inputStream) throws SerializationException {
            return (T)this.protocol.deserialize(inputStream);
        }

        public <T> T deserialize(InputStream inputStream, ClassLoader classLoader) throws SerializationException {
            return (T)this.protocol.deserialize(inputStream, classLoader);
        }

        private <T> T executeIndicatingLegacySerialization(SerializationException originalException, Supplier<T> supplier) {
            BatchEventSerializer.setLegacyBatchEventSerializer();
            try {
                T t = supplier.get();
                return t;
            }
            catch (Throwable throwable) {
                throw originalException;
            }
            finally {
                BatchEventSerializer.unsetLegacyBatchEventSerializer();
            }
        }
    }
}

