/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.queue;

import com.mulesoft.mule.runtime.module.batch.BatchProcessingListener;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.buffer.BatchContextTransactionManager;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.engine.queue.AbstractBatchQueueDelegate;
import java.util.Collection;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.queue.QueueManager;

public class SteppingQueueDelegate
extends AbstractBatchQueueDelegate {
    private final List<BatchProcessingListener> listeners;

    public SteppingQueueDelegate(BatchJobInstanceAdapter jobInstance, QueueManager queueManager, long queueTimeout, ObjectSerializer serializer, MuleContext muleContext, List<BatchProcessingListener> listeners) {
        super(jobInstance, queueManager, queueTimeout, serializer, muleContext);
        this.listeners = listeners;
    }

    @Override
    public void dispatch(BatchTransactionContext ctx, Collection<Record> records) throws MuleException {
        super.dispatch(ctx, records);
        this.notifyListeners(records);
    }

    @Override
    protected String buildQueueName() {
        return String.format("BSQ-%s-%s", this.jobInstance.getOwnerJobName(), this.jobInstance.getId());
    }

    @Override
    public void dispatchAndCommit(BatchTransactionContext ctx, BatchJobInstanceAdapter jobInstance, List<Record> records, BatchContextTransactionManager manager) {
        try {
            super.dispatch(ctx, records);
            manager.commit(ctx);
            this.notifyListeners(records);
        }
        catch (MuleException e) {
            manager.rollback(ctx, jobInstance, records, e);
        }
    }

    private void notifyListeners(Collection<Record> records) {
        if (this.listeners != null) {
            for (BatchProcessingListener listener : this.listeners) {
                listener.onSteppingQueueDispatch(this.jobInstance, records);
            }
        }
    }
}

