/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.mulesoft.mule.runtime.module.batch.BatchEvent;
import com.mulesoft.mule.runtime.module.batch.BatchEventWithSecurity;
import com.mulesoft.mule.runtime.module.batch.internal.kryo.LegacyBatchEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BatchEventSerializer
extends Serializer<BatchEvent> {
    private static final String BATCH_EVENT_WITH_SECURITY_WRITE = "BatchEventWithSecurityWrite";
    private static final String BATCH_EVENT_READ = "BatchEventRead";
    private static final String BATCH_EVENT_WITH_SECURITY_READ = "BatchEventWithSecurityRead";
    private static final ThreadLocal<Boolean> useLegacyBatchEventSerializer = new ThreadLocal();
    private final Map<String, FieldSerializer> fieldSerializerMap = new HashMap<String, FieldSerializer>();
    private FieldSerializer<LegacyBatchEvent> legacyBatchEventSerializer;

    public BatchEventSerializer(Kryo kryo) {
        this.init(kryo);
    }

    public static void setLegacyBatchEventSerializer() {
        useLegacyBatchEventSerializer.set(true);
    }

    public static void unsetLegacyBatchEventSerializer() {
        useLegacyBatchEventSerializer.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Kryo kryo) {
        this.legacyBatchEventSerializer = new FieldSerializer(kryo, LegacyBatchEvent.class);
        if (this.fieldSerializerMap.isEmpty()) {
            BatchEventSerializer batchEventSerializer = this;
            synchronized (batchEventSerializer) {
                this.fieldSerializerMap.put(BATCH_EVENT_WITH_SECURITY_WRITE, new FieldSerializer(kryo, BatchEventWithSecurity.class));
                this.fieldSerializerMap.put(BATCH_EVENT_READ, new FieldSerializer(kryo, BatchEvent.class));
                this.fieldSerializerMap.put(BATCH_EVENT_WITH_SECURITY_READ, new FieldSerializer(kryo, BatchEventWithSecurity.class));
            }
        }
    }

    public void write(Kryo kryo, Output output, BatchEvent event) {
        FieldSerializer fieldSerializer = this.fieldSerializerMap.get(BATCH_EVENT_WITH_SECURITY_WRITE);
        if (event instanceof BatchEventWithSecurity) {
            fieldSerializer.write(kryo, output, (Object)((BatchEventWithSecurity)event));
        } else {
            fieldSerializer.write(kryo, output, (Object)event);
        }
    }

    public BatchEventWithSecurity read(Kryo kryo, Input input, Class<BatchEvent> type) {
        FieldSerializer fieldSerializer;
        BatchEvent batchEvent = null;
        BatchEventWithSecurity batchEventWithSecuity = null;
        if (Boolean.TRUE.equals(useLegacyBatchEventSerializer.get())) {
            LegacyBatchEvent legacyBatchEvent = (LegacyBatchEvent)this.legacyBatchEventSerializer.read(kryo, input, LegacyBatchEvent.class);
            return new BatchEventWithSecurity(legacyBatchEvent.getCorrelationId(), legacyBatchEvent.getVariables(), legacyBatchEvent.getComponentLocation(), Optional.empty(), null);
        }
        if (type.getTypeName().equals(BatchEventWithSecurity.class.getName())) {
            fieldSerializer = this.fieldSerializerMap.get(BATCH_EVENT_WITH_SECURITY_READ);
            batchEventWithSecuity = (BatchEventWithSecurity)fieldSerializer.read(kryo, input, BatchEventWithSecurity.class);
        } else {
            fieldSerializer = this.fieldSerializerMap.get(BATCH_EVENT_READ);
            batchEvent = (BatchEvent)fieldSerializer.read(kryo, input, BatchEvent.class);
        }
        if (batchEventWithSecuity != null) {
            return batchEventWithSecuity;
        }
        BatchEventWithSecurity batchEventWithSecurityObj = new BatchEventWithSecurity(batchEvent.getCorrelationId(), batchEvent.getVariables(), batchEvent.getComponentLocation(), batchEvent.getLoggingVariables(), null);
        return batchEventWithSecurityObj;
    }
}

