/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.common.loader.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.mule.datasense.common.loader.json.JsonArrayStrategy;
import org.mule.datasense.common.loader.json.JsonMatcherException;
import org.mule.datasense.common.loader.json.JsonMatcherStrategy;
import org.mule.datasense.common.loader.json.JsonObjectStrategy;

public class JsonMatcher {
    private JsonMatcherStrategy jsonMatcherStrategy;

    static Stream<JsonElement> jsonArrayStream(JsonArray jsonArray) {
        return IntStream.range(0, jsonArray.size()).mapToObj(arg_0 -> ((JsonArray)jsonArray).get(arg_0));
    }

    public static Optional<JsonMatcher> createMatcher(JsonElement jsonElement) {
        if (jsonElement == null) {
            return Optional.empty();
        }
        return Optional.of(new JsonMatcher(JsonMatcher.createStrategy(jsonElement)));
    }

    public static Optional<JsonMatcher> match(JsonElement jsonElement, String name) {
        return JsonMatcher.createMatcher(jsonElement).flatMap(jsonMatcher -> jsonMatcher.match(name));
    }

    static JsonMatcher createRequiredMatcher(JsonElement jsonElement) {
        return JsonMatcher.createMatcher(jsonElement).orElseThrow(IllegalArgumentException::new);
    }

    static JsonMatcherStrategy createStrategy(JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject) {
            return new JsonObjectStrategy((JsonObject)jsonElement);
        }
        if (jsonElement instanceof JsonArray) {
            return new JsonArrayStrategy((JsonArray)jsonElement);
        }
        throw new IllegalArgumentException();
    }

    private JsonMatcher(JsonMatcherStrategy jsonMatcherStrategy) {
        this.jsonMatcherStrategy = jsonMatcherStrategy;
    }

    public Optional<JsonMatcher> match(String name) {
        return this.jsonMatcherStrategy.match(name);
    }

    public JsonMatcher require(String name) {
        return this.jsonMatcherStrategy.match(name).orElseThrow(() -> new JsonMatcherException(String.format("Missing required '%s'", name)));
    }

    public Optional<Stream<JsonMatcher>> matchMany(String name) {
        return this.jsonMatcherStrategy.matchMany(name);
    }

    public Stream<JsonMatcher> requireMany(String name) {
        return this.jsonMatcherStrategy.matchMany(name).orElseThrow(() -> new JsonMatcherException(String.format("Missing required many '%s'", name)));
    }

    public Optional<Stream<JsonMatcher>> matchMany() {
        return this.jsonMatcherStrategy.matchMany();
    }

    public Optional<JsonPrimitive> matchAttribute(String name) {
        return this.jsonMatcherStrategy.matchAttribute(name);
    }

    public Optional<String> matchString(String name) {
        return this.jsonMatcherStrategy.matchAttribute(name).map(jsonPrimitive -> jsonPrimitive.getAsString());
    }

    public JsonPrimitive requireAttribute(String name) {
        return this.matchAttribute(name).orElseThrow(() -> new JsonMatcherException(String.format("Missing attribute '%s'", name)));
    }

    public String requireString(String name) {
        return this.requireAttribute(name).getAsString();
    }

    public JsonElement element() {
        return this.jsonMatcherStrategy.element();
    }
}

