/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.license.internal;

import com.mulesoft.mule.runtime.module.license.internal.SecurityUtils;
import com.mulesoft.mule.runtime.module.license.internal.ZippedBundle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PublicKey;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ProviderLicense {
    public static final String CONTACT_EMAIL_KEY = "contact.email";
    public static final String CONTACT_MESSAGE_KEY = "contact.message";
    public static final String CONNECTOR_NAME_KEY = "connector.name";
    public static final String RSA_ECB_PKCS1_PADDING = "RSA/ECB/PKCS1Padding";
    private final String name;
    private final PublicKey key;
    private final Properties metadata;
    private final String pubKeyFile;
    private final String bundleFile;
    private final String pluginName;
    private final String providerName;
    private final String transformation;
    private String infoFile;

    public ProviderLicense(String providerName, String pluginName, ClassLoader pluginClassLoader, Key muleDecryptionKey, String transformation) throws InvalidKeyException {
        if (org.mule.runtime.core.api.util.StringUtils.isBlank((String)providerName)) {
            throw new IllegalArgumentException("Vendor name cannot be blank");
        }
        this.transformation = transformation;
        this.pluginName = pluginName;
        this.providerName = providerName;
        this.name = String.valueOf(StringUtils.uncapitalize((String)providerName.replace(" ", ""))) + "-" + pluginName;
        this.infoFile = this.name.concat(".info");
        this.bundleFile = this.name.concat(".key");
        this.pubKeyFile = this.name.concat(".pub");
        ZippedBundle keyBundle = this.unzipBundle(this.bundleFile, pluginClassLoader);
        this.key = this.loadPublicKey(muleDecryptionKey, keyBundle);
        this.metadata = this.loadMetaData(muleDecryptionKey, keyBundle);
        if (!this.getProperty(CONNECTOR_NAME_KEY).isPresent()) {
            throw new InvalidKeyException("Provided key is incomplete. No connector name information found");
        }
        if (!StringUtils.equals((CharSequence)this.getProperty(CONNECTOR_NAME_KEY).get(), (CharSequence)pluginName)) {
            throw new InvalidKeyException("Provided key " + this.name + " is not valid for this connector. It was created for " + this.getProperty(CONNECTOR_NAME_KEY).get() + " but expected to be " + pluginName);
        }
    }

    public ProviderLicense(String providerName, String pluginName, ClassLoader pluginClassLoader, Key muleDecryptionKey) throws InvalidKeyException {
        this(providerName, pluginName, pluginClassLoader, muleDecryptionKey, RSA_ECB_PKCS1_PADDING);
    }

    public PublicKey getKey() {
        return this.key;
    }

    public String getExpectedLicenseName() {
        return this.pluginName.concat(".lic");
    }

    public String getEmail() {
        return this.getProperty(CONTACT_EMAIL_KEY).get();
    }

    public String getContactMessage() {
        return this.getProperty(CONTACT_MESSAGE_KEY).get();
    }

    public String getProviderName() {
        return this.providerName;
    }

    public Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(this.metadata.getProperty(propertyName));
    }

    private Properties loadMetaData(Key muleDecryptionKey, ZippedBundle bundleFiles) throws InvalidKeyException {
        Optional<byte[]> info = bundleFiles.get(this.infoFile);
        if (!info.isPresent()) {
            throw new InvalidKeyException("Failed to decrypt " + this.pubKeyFile + ". No metadata file named  " + this.infoFile + "  found in " + this.bundleFile);
        }
        try {
            Properties metadata = new Properties();
            metadata.load(new ByteArrayInputStream(SecurityUtils.decrypt(info.get(), muleDecryptionKey, this.transformation)));
            return metadata;
        }
        catch (Exception e) {
            throw new InvalidKeyException("Failed to load " + this.infoFile + " found in " + this.bundleFile, e);
        }
    }

    private PublicKey loadPublicKey(Key muleDecryptionKey, ZippedBundle bundleFiles) throws InvalidKeyException {
        Optional<byte[]> pub = bundleFiles.get(this.pubKeyFile);
        if (!pub.isPresent()) {
            throw new InvalidKeyException("Failed to decrypt " + this.pubKeyFile + ". No public key name " + this.pubKeyFile + " found in bundle " + this.bundleFile);
        }
        try {
            return SecurityUtils.loadPublic(SecurityUtils.decrypt(pub.get(), muleDecryptionKey, this.transformation));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidKeyException("Failed to decrypt " + this.pubKeyFile + " found in " + this.bundleFile, e);
        }
    }

    private ZippedBundle unzipBundle(String file, ClassLoader classLoader) {
        InputStream bundleIS = classLoader.getResourceAsStream(file);
        if (bundleIS == null) {
            throw new IllegalArgumentException("Vendor key bundle for name [" + file + "] not found as resource");
        }
        return new ZippedBundle(bundleIS);
    }
}

