/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.feature.internal.config.profiling;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.feature.internal.config.profiling.ProfilingDataProducerStatus;
import org.mule.runtime.feature.internal.togglz.MuleTogglzProfilingFeature;
import org.mule.runtime.feature.internal.togglz.config.MuleTogglzFeatureFlaggingUtils;
import org.mule.runtime.feature.internal.togglz.provider.DefaultMuleTogglzFeatureProvider;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.user.FeatureUser;

public class MuleProfilingDataProducerFeatureStatus
implements ProfilingDataProducerStatus {
    private final Set<FeatureState> profilingFeaturesStates = ConcurrentHashMap.newKeySet();
    private final DefaultMuleTogglzFeatureProvider featureProvider;
    private final ProfilingEventType<?> profilingEventType;
    private final FeatureUser featureUser;

    public MuleProfilingDataProducerFeatureStatus(ProfilingEventType<?> profilingEventType, DefaultMuleTogglzFeatureProvider featureProvider, FeatureUser featureUser) {
        this.featureProvider = featureProvider;
        this.profilingEventType = profilingEventType;
        this.featureUser = featureUser;
        this.resetFeatureStates();
    }

    private void resetFeatureStates() {
        MuleTogglzFeatureFlaggingUtils.withFeatureUser(this.featureUser, () -> {
            Collection<MuleTogglzProfilingFeature> profilingFeatures = this.featureProvider.getConsumerFeaturesFor(this.profilingEventType);
            for (Feature feature : profilingFeatures) {
                this.profilingFeaturesStates.add(MuleTogglzFeatureFlaggingUtils.getFeatureState(feature));
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return this.profilingFeaturesStates.stream().anyMatch(profilingFeatureState -> profilingFeatureState.isEnabled());
    }

    @Override
    public void reset() {
        this.resetFeatureStates();
    }
}

