/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.metrics.event.status;

import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.metrics.event.status.RequestsPerApi;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiRequestsTracker
implements ApiDeploymentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiRequestsTracker.class);
    private static final int INITIAL_MAP_CAPACITY = 1000;
    private ApiService apiService;
    private Map<Long, AtomicLong> requestsPerApi;

    public ApiRequestsTracker(ApiService apiService) {
        this.apiService = apiService;
        this.requestsPerApi = this.newMap();
    }

    public void onApiDeploymentStart(Api api) {
        this.requestsPerApi.put(api.getKey().id(), new AtomicLong());
    }

    public ApiRequestsTracker addRequest(long apiId) {
        return this.addRequests(apiId, 1L);
    }

    ApiRequestsTracker addRequests(long apiId, long requests) {
        try {
            this.requestsPerApi.get(apiId).addAndGet(requests);
        }
        catch (Throwable t) {
            LOGGER.trace("Suppressing unexpected error while counting tps for api {}.", (Object)apiId, (Object)t);
        }
        return this;
    }

    public RequestsPerApi getRequestsAndReset() {
        Map<Long, AtomicLong> oldRequestsPerApi = this.requestsPerApi;
        Map<Long, AtomicLong> newRequestsPerApi = this.newMap();
        this.apiService.getApis().forEach(api -> newRequestsPerApi.put(api.getKey().id(), new AtomicLong()));
        this.requestsPerApi = newRequestsPerApi;
        return new RequestsPerApi(oldRequestsPerApi);
    }

    private Map<Long, AtomicLong> newMap() {
        return new HashMap<Long, AtomicLong>(1000);
    }

    public String toString() {
        return this.requestsPerApi.toString();
    }
}

