/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license.wizard;

import com.nexes.wizard.WizardModel;
import com.nexes.wizard.WizardPanelDescriptor;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.wizard.Resources;
import de.schlichtherle.swing.Defaults;
import de.schlichtherle.swing.EnhancedRadioButton;
import de.schlichtherle.swing.SwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class WelcomePanel
extends JPanel {
    private final LicenseManager manager;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private EnhancedRadioButton installButton;
    private EnhancedRadioButton verifyButton;
    private JTextArea welcome;

    public WelcomePanel(LicenseManager licenseManager) {
        this.manager = licenseManager;
        this.initComponents();
    }

    private void initComponents() {
        this.welcome = new JTextArea();
        this.installButton = new EnhancedRadioButton();
        this.verifyButton = new EnhancedRadioButton();
        this.setLayout(new GridBagLayout());
        this.welcome.setEditable(false);
        this.welcome.setFont(Defaults.labelBoldFont);
        this.welcome.setLineWrap(true);
        this.welcome.setText(Resources.getString("WelcomePanel.welcome.text", new Object[]{this.manager.getLicenseParam().getSubject()}));
        this.welcome.setWrapStyleWord(true);
        this.welcome.setBorder(null);
        this.welcome.setOpaque(false);
        this.welcome.setPreferredSize(new Dimension(370, 90));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.welcome, gridBagConstraints);
        this.buttonGroup.add((AbstractButton)this.installButton);
        this.installButton.setSelected(true);
        this.installButton.setText(Resources.getString("WelcomePanel.installButton.text"));
        this.installButton.setActionCommand("INSTALL_PANEL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.installButton, gridBagConstraints);
        this.buttonGroup.add((AbstractButton)this.verifyButton);
        this.verifyButton.setText(Resources.getString("WelcomePanel.verifyButton.text"));
        this.verifyButton.setActionCommand("LICENSE_PANEL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.verifyButton, gridBagConstraints);
    }

    private void startVerifyingLicense(final WizardModel wizardModel) {
        wizardModel.setNextButtonEnabled(Boolean.FALSE);
        this.installButton.setEnabled(false);
        this.verifyButton.setEnabled(false);
        Thread thread = new Thread(){

            public void run() {
                try {
                    WelcomePanel.this.manager.verify();
                    SwingUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        public void run() {
                            WelcomePanel.this.installButton.setEnabled(true);
                            WelcomePanel.this.verifyButton.setEnabled(true);
                            WelcomePanel.this.buttonGroup.setSelected(WelcomePanel.this.verifyButton.getModel(), true);
                            wizardModel.setNextButtonEnabled(Boolean.TRUE);
                        }
                    });
                }
                catch (Exception exception) {
                    try {
                        SwingUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            public void run() {
                                WelcomePanel.this.installButton.setEnabled(true);
                                WelcomePanel.this.verifyButton.setEnabled(false);
                                WelcomePanel.this.buttonGroup.setSelected(WelcomePanel.this.installButton.getModel(), true);
                                wizardModel.setNextButtonEnabled(Boolean.TRUE);
                            }
                        });
                    }
                    catch (Exception exception2) {
                        throw new AssertionError((Object)exception2);
                    }
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public static class Descriptor
    extends WizardPanelDescriptor {
        public static final String IDENTIFIER = "WELCOME_PANEL";

        public Descriptor(LicenseManager licenseManager) {
            super((Object)IDENTIFIER, (Component)new WelcomePanel(licenseManager));
        }

        public Object getNextPanelDescriptor() {
            return ((WelcomePanel)this.getPanelComponent()).buttonGroup.getSelection().getActionCommand();
        }

        public Object getBackPanelDescriptor() {
            return null;
        }

        public void aboutToDisplayPanel() {
            WelcomePanel welcomePanel = (WelcomePanel)this.getPanelComponent();
            welcomePanel.startVerifyingLicense(this.getWizardModel());
        }
    }
}

