/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.transaction.TransactionManager;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.SingleResourceTransactionFactoryManager;
import org.mule.runtime.core.api.config.FeatureContext;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.FlowTraceManager;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.RollbackSourceCallback;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.management.stats.ProcessingTimeWatcher;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.transformer.DataTypeConversionResolver;
import org.mule.runtime.core.api.util.StreamCloserService;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.internal.config.ClusterConfiguration;
import org.mule.runtime.core.internal.config.DefaultCustomizationService;
import org.mule.runtime.core.internal.config.ExpressionCorrelationIdGenerator;
import org.mule.runtime.core.internal.config.NullClusterConfiguration;
import org.mule.runtime.core.internal.connector.DefaultSchedulerController;
import org.mule.runtime.core.internal.connector.SchedulerController;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.exception.ErrorHandlerFactory;
import org.mule.runtime.core.internal.exception.GlobalErrorHandler;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.LifecycleStrategy;
import org.mule.runtime.core.internal.lifecycle.MuleContextLifecycleManager;
import org.mule.runtime.core.internal.lifecycle.MuleLifecycleInterceptor;
import org.mule.runtime.core.internal.logging.LogUtil;
import org.mule.runtime.core.internal.profiling.AbstractProfilingService;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.internal.transformer.simple.ObjectToString;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.core.internal.util.JdkVersionUtils;
import org.mule.runtime.core.internal.util.splash.ArtifactShutdownSplashScreen;
import org.mule.runtime.core.internal.util.splash.ArtifactStartupSplashScreen;
import org.mule.runtime.core.internal.util.splash.ServerShutdownSplashScreen;
import org.mule.runtime.core.internal.util.splash.ServerStartupSplashScreen;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Hooks;

public class DefaultMuleContext
implements MuleContextWithRegistry,
PrivilegedMuleContext {
    public static final String LOCAL_OBJECT_STORE_MANAGER_KEY = "_muleLocalObjectStoreManager";
    public static final String LOCAL_QUEUE_MANAGER_KEY = "_localQueueManager";
    public static final ThreadLocal<MuleContext> currentMuleContext = new ThreadLocal();
    private static Logger LOGGER = LoggerFactory.getLogger(DefaultMuleContext.class);
    private final CustomizationService customizationService = new DefaultCustomizationService();
    private MuleRegistry muleRegistryHelper;
    private Injector injector;
    private final AllStatistics stats = new AllStatistics();
    private volatile SchedulerService schedulerService;
    private MuleContextLifecycleManager lifecycleManager;
    private final Object lifecycleStateLock = new Object();
    private ServerNotificationManager notificationManager;
    private MuleConfiguration config;
    private String id;
    private long startDate;
    private volatile StreamCloserService streamCloserService;
    private final Object streamCloserServiceLock = new Object();
    private ClassLoader executionClassLoader;
    protected SystemExceptionHandler exceptionListener;
    private SchedulerController schedulerController = new DefaultSchedulerController();
    private ClusterConfiguration clusterConfiguration = new NullClusterConfiguration();
    private String clusterNodeIdPrefix = "";
    private final SingleResourceTransactionFactoryManager singleResourceTransactionFactoryManager = new SingleResourceTransactionFactoryManager();
    private LockFactory lockFactory;
    private ExtendedExpressionManager expressionManager;
    private ProcessingTimeWatcher processingTimeWatcher;
    private final Latch startLatch = new Latch();
    private QueueManager queueManager;
    private ExtensionManager extensionManager;
    private SecurityManager securityManager;
    private ObjectSerializer objectSerializer;
    private volatile DataTypeConversionResolver dataTypeConversionResolver;
    private final Object dataTypeConversionResolverLock = new Object();
    private volatile FlowTraceManager flowTraceManager;
    private final Object flowTraceManagerLock = new Object();
    private volatile EventContextService eventContextService;
    private final Object eventContextServiceLock = new Object();
    private volatile Collection<ExceptionContextProvider> exceptionContextProviders;
    private final Object exceptionContextProvidersLock = new Object();
    private TransformationService transformationService;
    private BootstrapServiceDiscoverer bootstrapServiceDiscoverer;
    private Properties deploymentProperties;
    private List<MuleContextListener> listeners = new CopyOnWriteArrayList<MuleContextListener>();
    private final LifecycleInterceptor lifecycleInterceptor = new MuleLifecycleInterceptor();
    @Inject
    private ComponentInitialStateManager componentInitialStateManager;
    private ArtifactType artifactType;
    private ErrorTypeLocator errorTypeLocator;
    private ErrorTypeRepository errorTypeRepository;
    private ConfigurationComponentLocator componentLocator;
    private LifecycleStrategy lifecycleStrategy = new DefaultLifecycleStrategy();
    private static final AtomicBoolean areFeatureFlagsConfigured = new AtomicBoolean();

    private static void configureUseTransactionSinkIndex() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.USE_TRANSACTION_SINK_INDEX, featureContext -> true);
    }

    public DefaultMuleContext() {
        this.transformationService = new ExtendedTransformationService(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() throws InitialisationException {
        Object object = this.lifecycleStateLock;
        synchronized (object) {
            this.lifecycleManager.checkPhase("initialise");
            if (this.getNotificationManager() == null) {
                throw new MuleRuntimeException(CoreMessages.objectIsNull("_muleNotificationManager"));
            }
            try {
                JdkVersionUtils.validateJdk();
            }
            catch (RuntimeException e) {
                throw new InitialisationException(CoreMessages.invalidJdk(SystemUtils.JAVA_VERSION, JdkVersionUtils.getSupportedJdks()), (Initialisable)this);
            }
            try {
                this.id = this.getConfiguration().getDomainId() + "." + this.getClusterId() + "." + this.getConfiguration().getId();
                this.getRegistry().initialise();
                this.fireNotification(new MuleContextNotification((MuleContext)this, 101));
                this.getLifecycleManager().fireLifecycle("initialise");
                this.fireNotification(new MuleContextNotification((MuleContext)this, 102));
                org.mule.runtime.api.artifact.Registry apiRegistry = this.getApiRegistry();
                this.listeners.forEach(l -> l.onInitialization(this, apiRegistry));
                this.lifecycleStrategy.initialise((Initialisable)this);
                this.getConfiguration().getDefaultCorrelationIdGenerator().ifPresent(generator -> {
                    if (generator instanceof ExpressionCorrelationIdGenerator) {
                        ((ExpressionCorrelationIdGenerator)generator).initializeGenerator();
                    }
                });
            }
            catch (InitialisationException e) {
                this.dispose();
                throw e;
            }
            catch (Exception e) {
                this.dispose();
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MuleException {
        Object object = this.lifecycleStateLock;
        synchronized (object) {
            this.getLifecycleManager().checkPhase("start");
            this.startDate = System.currentTimeMillis();
            this.fireNotification(new MuleContextNotification((MuleContext)this, 103));
            this.getLifecycleManager().fireLifecycle("start");
            this.lifecycleStrategy.start((Startable)this);
            this.fireNotification(new MuleContextNotification((MuleContext)this, 104));
            org.mule.runtime.api.artifact.Registry apiRegistry = this.getApiRegistry();
            this.listeners.forEach(l -> l.onStart(this, apiRegistry));
            this.startLatch.release();
            if (LOGGER.isInfoEnabled()) {
                SplashScreen startupScreen = this.buildStartupSplash();
                LogUtil.log(startupScreen.toString());
            }
        }
    }

    private void startMessageSources() throws LifecycleException {
        this.startPipelineMessageSources();
    }

    private void startPipelineMessageSources() throws LifecycleException {
        for (Pipeline pipeline : this.getRegistry().lookupObjectsForLifecycle(Pipeline.class)) {
            MessageSource messageSource;
            if (!pipeline.getLifecycleState().isStarted() || (messageSource = pipeline.getSource()) == null || !this.componentInitialStateManager.mustStartMessageSource((Component)messageSource)) continue;
            this.startMessageSource(messageSource);
        }
    }

    private void startMessageSource(MessageSource messageSource) throws LifecycleException {
        try {
            LifecycleUtils.startIfNeeded(messageSource);
        }
        catch (ConnectException e) {
            this.exceptionListener.handleException((Exception)((Object)e));
        }
        catch (LifecycleException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e, (Object)messageSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws MuleException {
        Object object = this.lifecycleStateLock;
        synchronized (object) {
            this.startLatch.release();
            this.getLifecycleManager().checkPhase("stop");
            this.fireNotification(new MuleContextNotification((MuleContext)this, 105));
            this.getLifecycleManager().fireLifecycle("stop");
            this.lifecycleStrategy.stop((Stoppable)this);
            this.fireNotification(new MuleContextNotification((MuleContext)this, 106));
            org.mule.runtime.api.artifact.Registry apiRegistry = this.getApiRegistry();
            this.listeners.forEach(l -> l.onStop(this, apiRegistry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lifecycleStateLock;
        synchronized (object) {
            if (this.isStarted() || this.lifecycleManager.getLastPhaseExecuted() != null && this.lifecycleManager.getLastPhaseExecuted().equals("start") && this.lifecycleManager.isLastPhaseExecutionFailed()) {
                try {
                    this.stop();
                }
                catch (MuleException e) {
                    LOGGER.error("Failed to stop Mule context", (Throwable)e);
                }
            }
            this.getLifecycleManager().checkPhase("dispose");
            this.fireNotification(new MuleContextNotification((MuleContext)this, 107));
            this.lifecycleStrategy.dispose((Disposable)this);
            LifecycleUtils.disposeIfNeeded(this.getExceptionListener(), LOGGER);
            try {
                this.getLifecycleManager().fireLifecycle("dispose");
                if (this.muleRegistryHelper != null) {
                    FunctionalUtils.safely(() -> this.muleRegistryHelper.dispose());
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to cleanly dispose Mule: " + e.getMessage(), (Throwable)e);
            }
            this.notificationManager.fireNotification((Notification)new MuleContextNotification((MuleContext)this, 108));
            this.disposeManagers();
            if (this.getStartDate() > 0L && LOGGER.isInfoEnabled()) {
                SplashScreen shutdownScreen = this.buildShutdownSplash();
                LogUtil.log(shutdownScreen.toString());
            }
            this.setExecutionClassLoader(null);
        }
    }

    private void disposeManagers() {
        FunctionalUtils.safely(() -> {
            LifecycleUtils.disposeIfNeeded(this.getFlowTraceManager(), LOGGER);
            this.notificationManager.dispose();
        });
    }

    @Override
    public boolean isInitialised() {
        return this.getLifecycleManager().getState().isInitialised();
    }

    @Override
    public boolean isInitialising() {
        return this.getLifecycleManager().getState().isInitialising();
    }

    @Override
    public boolean isStopped() {
        return this.getLifecycleManager().getState().isStopped();
    }

    @Override
    public boolean isStopping() {
        return this.getLifecycleManager().getState().isStopping();
    }

    @Override
    public boolean isStarted() {
        return this.getLifecycleManager().isPhaseComplete("start");
    }

    @Override
    public boolean isStarting() {
        return this.getLifecycleManager().getState().isStarting();
    }

    @Override
    public boolean isDisposed() {
        return this.getLifecycleManager().getState().isDisposed();
    }

    @Override
    public boolean isDisposing() {
        return this.getLifecycleManager().getState().isDisposing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withLifecycleLock(Runnable command) {
        Object object = this.lifecycleStateLock;
        synchronized (object) {
            command.run();
        }
    }

    @Override
    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public AllStatistics getStatistics() {
        return this.stats;
    }

    private void fireNotification(AbstractServerNotification notification) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.fireNotification((Notification)notification);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MuleEvent Manager is not enabled, ignoring notification: " + notification);
        }
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) {
        this.checkLifecycleForPropertySet("_muleSecurityManager", "initialise");
        try {
            this.muleRegistryHelper.registerObject("_muleSecurityManager", securityManager);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException((Throwable)((Object)e));
        }
        this.securityManager = securityManager;
    }

    @Override
    public SecurityManager getSecurityManager() {
        if (this.securityManager == null) {
            this.securityManager = this.fetchSecurityManager();
        }
        return this.securityManager;
    }

    private SecurityManager fetchSecurityManager() {
        Collection<SecurityManager> temp;
        SecurityManager securityManager = (SecurityManager)this.muleRegistryHelper.lookupObject("_muleSecurityManager");
        if (securityManager == null && (temp = this.muleRegistryHelper.lookupObjects(SecurityManager.class)).size() > 0) {
            securityManager = temp.iterator().next();
        }
        if (securityManager == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("securityManager"));
        }
        return securityManager;
    }

    @Override
    public SchedulerService getSchedulerService() {
        if (this.schedulerService == null) {
            try {
                this.schedulerService = this.getRegistry().lookupObject(SchedulerService.class);
                Objects.requireNonNull(this.schedulerService);
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException((Throwable)((Object)e));
            }
        }
        return this.schedulerService;
    }

    @Override
    public SchedulerConfig getSchedulerBaseConfig() {
        return (SchedulerConfig)this.getRegistry().lookupObject("_muleSchedulerBaseConfig");
    }

    @Override
    public QueueManager getQueueManager() {
        if (this.queueManager == null) {
            Collection<QueueManager> temp;
            this.queueManager = (QueueManager)this.muleRegistryHelper.lookupObject("_muleQueueManager");
            if (this.queueManager == null && (temp = this.muleRegistryHelper.lookupObjects(QueueManager.class)).size() > 0) {
                this.queueManager = temp.iterator().next();
            }
        }
        return this.queueManager;
    }

    @Override
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public LifecycleInterceptor getLifecycleInterceptor() {
        return this.lifecycleInterceptor;
    }

    @Override
    public ObjectStoreManager getObjectStoreManager() {
        return (ObjectStoreManager)this.getRegistry().lookupObject("_muleObjectStoreManager");
    }

    @Override
    public ObjectSerializer getObjectSerializer() {
        return this.objectSerializer;
    }

    public ObjectStoreManager getLocalObjectStoreManager() {
        return (ObjectStoreManager)this.getRegistry().lookupObject(LOCAL_OBJECT_STORE_MANAGER_KEY);
    }

    public QueueManager getLocalQueueManager() {
        return (QueueManager)this.getRegistry().lookupObject(LOCAL_QUEUE_MANAGER_KEY);
    }

    @Override
    public void setQueueManager(QueueManager queueManager) {
        try {
            this.getRegistry().registerObject("_muleQueueManager", queueManager);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException((Throwable)((Object)e));
        }
        this.queueManager = queueManager;
    }

    @Override
    public MuleConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public ServerNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @Override
    public void setTransactionManager(TransactionManager manager) throws RegistrationException {
        this.muleRegistryHelper.registerObject("_muleTransactionManager", manager);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return (TransactionManager)this.getRegistry().lookupObject("_muleTransactionManager");
    }

    protected void checkLifecycleForPropertySet(String propertyName, String phase) throws IllegalStateException {
        if (this.lifecycleManager.isPhaseComplete(phase)) {
            throw new IllegalStateException("Cannot set property: '" + propertyName + "' once the server has already been through the " + phase + " phase.");
        }
    }

    @Override
    public MuleRegistry getRegistry() {
        return this.muleRegistryHelper;
    }

    @Override
    public void setRegistry(Registry registry) {
        if (!(registry instanceof MuleRegistryHelper)) {
            registry = new MuleRegistryHelper(registry, this);
        }
        this.muleRegistryHelper = (MuleRegistryHelper)registry;
    }

    public void setLifecycleStrategy(LifecycleStrategy lifecycleStrategy) {
        this.lifecycleStrategy = lifecycleStrategy;
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamCloserService getStreamCloserService() {
        if (this.streamCloserService == null) {
            Object object = this.streamCloserServiceLock;
            synchronized (object) {
                if (this.streamCloserService == null) {
                    this.streamCloserService = (StreamCloserService)this.getRegistry().lookupObject("_muleStreamCloserService");
                }
            }
        }
        return this.streamCloserService;
    }

    @Override
    public long getStartDate() {
        return this.startDate;
    }

    @Override
    public void setExecutionClassLoader(ClassLoader cl) {
        this.executionClassLoader = cl;
    }

    @Override
    public ClassLoader getExecutionClassLoader() {
        return this.executionClassLoader;
    }

    private SplashScreen buildStartupSplash() {
        SplashScreen startupScreen = this.config.isContainerMode() ? new ArtifactStartupSplashScreen() : new ServerStartupSplashScreen();
        startupScreen.setHeader(this);
        startupScreen.setFooter(this);
        return startupScreen;
    }

    private SplashScreen buildShutdownSplash() {
        SplashScreen shutdownScreen = this.config.isContainerMode() ? new ArtifactShutdownSplashScreen() : new ServerShutdownSplashScreen();
        shutdownScreen.setHeader(this);
        return shutdownScreen;
    }

    @Override
    public void handleException(Exception e, RollbackSourceCallback rollbackMethod) {
        this.getExceptionListener().handleException(e, rollbackMethod);
    }

    @Override
    public void handleException(Exception e) {
        this.handleException(e, null);
    }

    @Override
    public SystemExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(SystemExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    @Override
    public String getClusterId() {
        return this.clusterConfiguration.getClusterId();
    }

    @Override
    public int getClusterNodeId() {
        return this.clusterConfiguration.getClusterNodeId();
    }

    public void setSchedulerController(SchedulerController schedulerController) {
        this.schedulerController = schedulerController;
    }

    @Override
    public boolean isPrimaryPollingInstance() {
        return this.schedulerController.isPrimarySchedulingInstance();
    }

    @Override
    public String getUniqueIdString() {
        return UUID.getClusterUUID(this.clusterNodeIdPrefix);
    }

    @Override
    public FlowExceptionHandler getDefaultErrorHandler(Optional<String> rootContainerName) {
        FlowExceptionHandler defaultErrorHandler;
        if (this.config.getDefaultErrorHandlerName() != null) {
            defaultErrorHandler = (FlowExceptionHandler)this.getRegistry().lookupObject(this.config.getDefaultErrorHandlerName());
            if (defaultErrorHandler == null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("No global error handler named %s", this.config.getDefaultErrorHandlerName())));
            }
            if (!TemplateOnErrorHandler.reuseGlobalErrorHandler()) {
                if (rootContainerName.isPresent()) {
                    defaultErrorHandler = ((GlobalErrorHandler)defaultErrorHandler).createLocalErrorHandler((ComponentLocation)this.getDefaultComponentLocation(rootContainerName.get()));
                } else {
                    try {
                        defaultErrorHandler = new ErrorHandlerFactory().createDefault(this.getRegistry().lookupObject(NotificationDispatcher.class));
                    }
                    catch (RegistrationException e) {
                        throw new MuleRuntimeException((Throwable)((Object)e));
                    }
                }
            }
        } else {
            try {
                defaultErrorHandler = new ErrorHandlerFactory().createDefault(this.getRegistry().lookupObject(NotificationDispatcher.class));
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException((Throwable)((Object)e));
            }
        }
        if (rootContainerName.isPresent() && defaultErrorHandler instanceof ErrorHandler) {
            ((ErrorHandler)defaultErrorHandler).setRootContainerName(rootContainerName.get());
        }
        return defaultErrorHandler;
    }

    private DefaultComponentLocation getDefaultComponentLocation(String name) {
        DefaultComponentLocation.DefaultLocationPart part = new DefaultComponentLocation.DefaultLocationPart(name, Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty());
        return new DefaultComponentLocation(Optional.of(name), Collections.singletonList(part));
    }

    @Override
    public SingleResourceTransactionFactoryManager getTransactionFactoryManager() {
        return this.singleResourceTransactionFactoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeConversionResolver getDataTypeConverterResolver() {
        if (this.dataTypeConversionResolver == null) {
            Object object = this.dataTypeConversionResolverLock;
            synchronized (object) {
                if (this.dataTypeConversionResolver == null) {
                    this.dataTypeConversionResolver = (DataTypeConversionResolver)this.getRegistry().lookupObject("_converterResolver");
                    if (this.dataTypeConversionResolver == null) {
                        this.dataTypeConversionResolver = new DynamicDataTypeConversionResolver(this);
                        try {
                            this.getRegistry().registerObject("_converterResolver", this.dataTypeConversionResolver);
                        }
                        catch (RegistrationException e) {
                            throw new IllegalStateException((Throwable)((Object)e));
                        }
                    }
                }
            }
        }
        return this.dataTypeConversionResolver;
    }

    @Override
    public ExtendedExpressionManager getExpressionManager() {
        if (this.expressionManager == null) {
            this.expressionManager = (ExtendedExpressionManager)this.muleRegistryHelper.lookupObject("_muleExpressionManager");
        }
        return this.expressionManager;
    }

    @Override
    public LockFactory getLockFactory() {
        if (this.lockFactory == null) {
            this.lockFactory = (LockFactory)this.muleRegistryHelper.get("_muleLockFactory");
        }
        return this.lockFactory;
    }

    @Override
    public ProcessingTimeWatcher getProcessorTimeWatcher() {
        if (this.processingTimeWatcher == null) {
            this.processingTimeWatcher = (ProcessingTimeWatcher)this.muleRegistryHelper.get("_muleProcessingTimeWatcher");
        }
        return this.processingTimeWatcher;
    }

    @Override
    public boolean waitUntilStarted(int timeout) throws InterruptedException {
        return this.startLatch.await((long)timeout, TimeUnit.MILLISECONDS);
    }

    private void overrideClusterConfiguration() {
        ClusterConfiguration overriddenClusterConfiguration = (ClusterConfiguration)this.getRegistry().get("_muleClusterConfiguration");
        if (overriddenClusterConfiguration != null) {
            this.clusterConfiguration = overriddenClusterConfiguration;
            this.clusterNodeIdPrefix = overriddenClusterConfiguration.getClusterNodeId() + "-";
        }
    }

    private void overridePollingController() {
        SchedulerController overriddenSchedulerController = (SchedulerController)this.getRegistry().get("_mulePollingController");
        if (overriddenSchedulerController != null) {
            this.schedulerController = overriddenSchedulerController;
        }
    }

    public void setMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.config = muleConfiguration;
    }

    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setLifecycleManager(LifecycleManager lifecycleManager) {
        if (!(lifecycleManager instanceof MuleContextLifecycleManager)) {
            I18nMessage msg = I18nMessageFactory.createStaticMessage((String)"lifecycle manager for MuleContext must be a MuleContextLifecycleManager");
            throw new MuleRuntimeException(msg);
        }
        this.lifecycleManager = (MuleContextLifecycleManager)lifecycleManager;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    @Override
    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
    }

    @Override
    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(ArtifactType artifactType) {
        this.artifactType = artifactType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowTraceManager getFlowTraceManager() {
        if (this.flowTraceManager == null) {
            Object object = this.flowTraceManagerLock;
            synchronized (object) {
                if (this.flowTraceManager == null) {
                    try {
                        this.flowTraceManager = this.getRegistry().lookupObject(FlowTraceManager.class);
                    }
                    catch (RegistrationException e) {
                        throw new IllegalStateException((Throwable)((Object)e));
                    }
                }
            }
        }
        return this.flowTraceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventContextService getEventContextService() {
        if (this.eventContextService == null) {
            Object object = this.eventContextServiceLock;
            synchronized (object) {
                if (this.eventContextService == null) {
                    try {
                        this.eventContextService = this.getRegistry().lookupObject(EventContextService.class);
                    }
                    catch (RegistrationException e) {
                        throw new IllegalStateException("Could not get 'EventContextService' instance from registry.", (Throwable)((Object)e));
                    }
                }
            }
        }
        return this.eventContextService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExceptionContextProvider> getExceptionContextProviders() {
        if (this.exceptionContextProviders == null) {
            Object object = this.exceptionContextProvidersLock;
            synchronized (object) {
                if (this.exceptionContextProviders == null) {
                    this.exceptionContextProviders = this.muleRegistryHelper.lookupByType(ExceptionContextProvider.class).values();
                }
            }
        }
        return this.exceptionContextProviders;
    }

    @Override
    public TransformationService getTransformationService() {
        if (this.transformationService == null) {
            this.transformationService = (TransformationService)this.getRegistry().get("_muleTransformationService");
        }
        return this.transformationService;
    }

    @Override
    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    @Override
    public BootstrapServiceDiscoverer getRegistryBootstrapServiceDiscoverer() {
        return this.bootstrapServiceDiscoverer;
    }

    @Override
    public CustomizationService getCustomizationService() {
        return this.customizationService;
    }

    @Override
    public void setBootstrapServiceDiscoverer(BootstrapServiceDiscoverer bootstrapServiceDiscoverer) {
        this.bootstrapServiceDiscoverer = bootstrapServiceDiscoverer;
    }

    @Override
    public ConfigurationComponentLocator getConfigurationComponentLocator() {
        if (this.componentLocator == null) {
            this.componentLocator = (ConfigurationComponentLocator)this.getRegistry().lookupObject("_muleConfigurationComponentLocator");
        }
        return this.componentLocator;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setErrorTypeLocator(ErrorTypeLocator errorTypeLocator) {
        this.errorTypeLocator = errorTypeLocator;
    }

    @Override
    public ErrorTypeLocator getErrorTypeLocator() {
        return this.errorTypeLocator;
    }

    @Override
    public ErrorTypeRepository getErrorTypeRepository() {
        return this.errorTypeRepository;
    }

    public void setErrorTypeRepository(ErrorTypeRepository errorTypeRepository) {
        this.errorTypeRepository = errorTypeRepository;
    }

    @Override
    public Properties getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public void setDeploymentProperties(Properties deploymentProperties) {
        this.deploymentProperties = deploymentProperties;
    }

    public void setListeners(List<MuleContextListener> listeners) {
        this.listeners = new CopyOnWriteArrayList<MuleContextListener>(listeners);
    }

    public void addListener(MuleContextListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MuleContextListener listener) {
        this.listeners.remove(listener);
    }

    private org.mule.runtime.api.artifact.Registry getApiRegistry() {
        return (org.mule.runtime.api.artifact.Registry)this.getRegistry().lookupObject("_muleRegistry");
    }

    private static void configureSplitterExceptionHandlingFeature() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.HANDLE_SPLITTER_EXCEPTION, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast("4.4.0")).isPresent());
    }

    private static void configureBatchFixedAggregatorTransactionRecordBuffer() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.BATCH_FIXED_AGGREGATOR_TRANSACTION_RECORD_BUFFER, featureContext -> false);
    }

    public static void configurePropertiesResolverFeatureFlag() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.HONOUR_RESERVED_PROPERTIES, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.newerThan("4.2.2")).isPresent());
    }

    private static void configureEnablePolicyIsolation() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.ENABLE_POLICY_ISOLATION, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast("4.4.0")).isPresent());
    }

    private static void configureEntityResolverFailOnFirstErrorFeature() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast("4.4.0")).isPresent());
    }

    private static void configureSetVariableWithNullVale() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.SET_VARIABLE_WITH_NULL_VALUE, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast("4.4.0")).isPresent());
    }

    private static void configureStartExtensionComponentsWithArtifactClassloader() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.START_EXTENSION_COMPONENTS_WITH_ARTIFACT_CLASSLOADER, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast("4.4.0")).isPresent());
    }

    private static void configureRemoveShadowedImplicitInputs() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.DW_REMOVE_SHADOWED_IMPLICIT_INPUTS, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast("4.4.0")).isPresent());
    }

    private static void configureDefaultErrorHandlerNotRollbackingEveryTx() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.DEFAULT_ERROR_HANDLER_NOT_ROLLBACK_IF_NOT_CORRESPONDING, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast("4.5.0")).isPresent());
    }

    private static void configureParallelForeachFlattenMessage() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.PARALLEL_FOREACH_FLATTEN_MESSAGE, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast("4.5.0")).isPresent());
    }

    private static void configureEnableByteBuddyObjectCreation() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.ENABLE_BYTE_BUDDY_OBJECT_CREATION, DefaultMuleContext.minMuleVersion("4.5.0"));
    }

    private static void configurePrintDetailedCompositeExceptionLog() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.MULE_PRINT_DETAILED_COMPOSITE_EXCEPTION_LOG, DefaultMuleContext.minMuleVersion("4.5.0"));
    }

    private static void configureHonourErrorMappingsWhenPolicyAppliedOnOperation() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.HONOUR_ERROR_MAPPINGS_WHEN_POLICY_APPLIED_ON_OPERATION, DefaultMuleContext.minMuleVersion("4.5.0"));
    }

    private static void configureSuppressErrors() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.SUPPRESS_ERRORS, featureContext -> true);
    }

    private static void configureRethrowExceptionsInIdempotentMessageValidator() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.RETHROW_EXCEPTIONS_IN_IDEMPOTENT_MESSAGE_VALIDATOR, DefaultMuleContext.minMuleVersion("4.5.0"));
    }

    private static void configureHonourInsecureTlsConfiguration() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.HONOUR_INSECURE_TLS_CONFIGURATION, DefaultMuleContext.minMuleVersion("4.5.0"));
    }

    private static void configureCreateChildPolicyContextForParallelScopes() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.CREATE_CHILD_POLICY_CONTEXT_FOR_PARALLEL_SCOPES, DefaultMuleContext.minMuleVersion("4.5.0"));
    }

    private static void configureDisableSchedulerLogging() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.DISABLE_SCHEDULER_LOGGING, DefaultMuleContext.minMuleVersion("4.6.0"));
    }

    private static void configureErrorAndRollbackTxWhenTimeout() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.ERROR_AND_ROLLBACK_TX_WHEN_TIMEOUT, DefaultMuleContext.minMuleVersion("4.6.1"));
    }

    private static void configureEnableXmlSdkReset() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.ENABLE_XML_SDK_MDC_RESET, DefaultMuleContext.minMuleVersion("4.8.0"));
    }

    private static void configureHonourPersistedFlowState() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.HONOUR_PERSISTED_FLOW_STATE, DefaultMuleContext.minMuleVersion("4.8.0"));
    }

    private static void configureForkJoinCompleteChildrenOnTimeout() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.FORK_JOIN_COMPLETE_CHILDREN_ON_TIMEOUT, DefaultMuleContext.minMuleVersion("4.10.0"));
    }

    private static Predicate<FeatureContext> minMuleVersion(String version) {
        return featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast(version)).isPresent();
    }

    static {
        Hooks.onErrorDropped(error -> LOGGER.debug("ERROR DROPPED", error));
        Hooks.onNextDropped(event -> LOGGER.debug("EVENT DROPPED {}", event));
        if (!areFeatureFlagsConfigured.getAndSet(true)) {
            DefaultMuleContext.configurePropertiesResolverFeatureFlag();
            DefaultMuleContext.configureSplitterExceptionHandlingFeature();
            DefaultMuleContext.configureBatchFixedAggregatorTransactionRecordBuffer();
            AllStatistics.configureComputeConnectionErrorsInStats();
            ObjectToString.configureToStringTransformerTransformIteratorElements();
            DefaultMuleContext.configureEnablePolicyIsolation();
            DefaultMuleContext.configureEntityResolverFailOnFirstErrorFeature();
            AbstractProfilingService.configureEnableProfilingService();
            DefaultMuleContext.configureSetVariableWithNullVale();
            DefaultMuleContext.configureStartExtensionComponentsWithArtifactClassloader();
            DefaultMuleContext.configureRemoveShadowedImplicitInputs();
            DefaultMuleContext.configureDefaultErrorHandlerNotRollbackingEveryTx();
            DefaultMuleContext.configureParallelForeachFlattenMessage();
            DefaultMuleContext.configureEnableByteBuddyObjectCreation();
            DefaultMuleContext.configurePrintDetailedCompositeExceptionLog();
            DefaultMuleContext.configureHonourErrorMappingsWhenPolicyAppliedOnOperation();
            DefaultMuleContext.configureSuppressErrors();
            DefaultMuleContext.configureRethrowExceptionsInIdempotentMessageValidator();
            DefaultMuleContext.configureHonourInsecureTlsConfiguration();
            DefaultMuleContext.configureUseTransactionSinkIndex();
            DefaultMuleContext.configureCreateChildPolicyContextForParallelScopes();
            DefaultMuleContext.configureDisableSchedulerLogging();
            DefaultMuleContext.configureErrorAndRollbackTxWhenTimeout();
            DefaultMuleContext.configureEnableXmlSdkReset();
            DefaultMuleContext.configureHonourPersistedFlowState();
            DefaultMuleContext.configureForkJoinCompleteChildrenOnTimeout();
        }
    }

    private class DefaultLifecycleStrategy
    implements LifecycleStrategy {
        private DefaultLifecycleStrategy() {
        }

        @Override
        public void initialise(Initialisable initialisable) throws InitialisationException {
            LifecycleUtils.initialiseIfNeeded(DefaultMuleContext.this.getExceptionListener(), true, (MuleContext)DefaultMuleContext.this);
            DefaultMuleContext.this.getNotificationManager().initialise();
            DefaultMuleContext.this.objectSerializer = (ObjectSerializer)DefaultMuleContext.this.muleRegistryHelper.get("_muleDefaultObjectSerializer");
        }

        @Override
        public void start(Startable startable) throws MuleException {
            if (DefaultMuleContext.this.getQueueManager() == null) {
                throw new MuleRuntimeException(CoreMessages.objectIsNull("queueManager"));
            }
            DefaultMuleContext.this.componentInitialStateManager = (ComponentInitialStateManager)DefaultMuleContext.this.muleRegistryHelper.get("_muleComponentInitialStateManager");
            DefaultMuleContext.this.overridePollingController();
            DefaultMuleContext.this.overrideClusterConfiguration();
            DefaultMuleContext.this.startMessageSources();
        }
    }
}

