/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.management.stats;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.mule.runtime.core.api.management.stats.FlowsSummaryStatistics;

public class DefaultFlowsSummaryStatistics
implements FlowsSummaryStatistics {
    private static final String APIKIT_FLOWNAME_REGEX = "(\\w*):(\\\\[^:]*)(:[^:]*)?:([^\\/\\\\\\[\\\\\\]\\{\\}#]*)";
    private static final String APIKIT_SOAP_FLOWNAME_REGEX = "(\\w*):\\\\([^\\/\\\\\\[\\\\\\]\\{\\}#]*)";
    private static final Pattern APIKIT_FLOWNAME_PATTERN = Pattern.compile("(\\w*):(\\\\[^:]*)(:[^:]*)?:([^\\/\\\\\\[\\\\\\]\\{\\}#]*)");
    private static final Pattern APIKIT_SOAP_FLOWNAME_PATTERN = Pattern.compile("(\\w*):\\\\([^\\/\\\\\\[\\\\\\]\\{\\}#]*)");
    private static final long serialVersionUID = 1L;
    private final boolean enabled;
    private final AtomicInteger declaredPrivateFlows = new AtomicInteger(0);
    private final AtomicInteger activePrivateFlows = new AtomicInteger(0);
    private final AtomicInteger declaredTriggerFlows = new AtomicInteger(0);
    private final AtomicInteger activeTriggerFlows = new AtomicInteger(0);
    private final AtomicInteger declaredApikitFlows = new AtomicInteger(0);
    private final AtomicInteger activeApikitFlows = new AtomicInteger(0);
    private final Set<String> declaredPrivateFlowNames = Collections.synchronizedSet(new HashSet());
    private final Set<String> declaredTriggerFlowNames = Collections.synchronizedSet(new HashSet());
    private final Set<String> declaredApiKitFlowNames = Collections.synchronizedSet(new HashSet());

    public DefaultFlowsSummaryStatistics(boolean isStatisticsEnabled) {
        this.enabled = isStatisticsEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public int incrementDeclaredPrivateFlow(String flowName) {
        this.declaredPrivateFlowNames.add(flowName);
        return this.declaredPrivateFlows.incrementAndGet();
    }

    public int incrementActivePrivateFlow() {
        return this.activePrivateFlows.incrementAndGet();
    }

    public int incrementDeclaredTriggerFlow(String flowName) {
        this.declaredTriggerFlowNames.add(flowName);
        return this.declaredTriggerFlows.incrementAndGet();
    }

    public int incrementActiveTriggerFlow() {
        return this.activeTriggerFlows.incrementAndGet();
    }

    public int incrementDeclaredApikitFlow(String flowName) {
        this.declaredApiKitFlowNames.add(flowName);
        return this.declaredApikitFlows.incrementAndGet();
    }

    public int incrementActiveApikitFlow() {
        return this.activeApikitFlows.incrementAndGet();
    }

    public int decrementActiveTriggerFlow() {
        return this.activeTriggerFlows.decrementAndGet();
    }

    public int decrementActivePrivateFlow() {
        return this.activePrivateFlows.decrementAndGet();
    }

    public int decrementActiveApikitFlow() {
        return this.activeApikitFlows.decrementAndGet();
    }

    public int decrementDeclaredPrivateFlow(String flowName) {
        this.declaredPrivateFlowNames.remove(flowName);
        return this.declaredPrivateFlows.decrementAndGet();
    }

    public int decrementDeclaredTriggerFlow(String flowName) {
        this.declaredTriggerFlowNames.remove(flowName);
        return this.declaredTriggerFlows.decrementAndGet();
    }

    public int decrementDeclaredApikitFlow(String flowName) {
        this.declaredApiKitFlowNames.remove(flowName);
        return this.declaredApikitFlows.decrementAndGet();
    }

    @Override
    public int getDeclaredPrivateFlows() {
        return this.declaredPrivateFlows.get();
    }

    @Override
    public int getActivePrivateFlows() {
        return this.activePrivateFlows.get();
    }

    @Override
    public int getDeclaredTriggerFlows() {
        return this.declaredTriggerFlows.get();
    }

    @Override
    public int getActiveTriggerFlows() {
        return this.activeTriggerFlows.get();
    }

    @Override
    public int getDeclaredApikitFlows() {
        return this.declaredApikitFlows.get();
    }

    @Override
    public int getActiveApikitFlows() {
        return this.activeApikitFlows.get();
    }

    public static boolean isApiKitFlow(String flowName) {
        return APIKIT_FLOWNAME_PATTERN.matcher(flowName).matches() || APIKIT_SOAP_FLOWNAME_PATTERN.matcher(flowName).matches();
    }

    public String toString() {
        return "\nFlows Summary: {\n\tFlows with event sources: {\n\t\tTotal: " + this.declaredTriggerFlowNames.size() + ",\n\t\tFlows: " + this.declaredTriggerFlowNames + "\n\t},\n\tNumber of implementation flows generated by APIKit: {\n\t\tTotal: " + this.declaredApiKitFlowNames.size() + ",\n\t\tFlows: " + this.declaredApiKitFlowNames + "\n\t}\n" + '}';
    }
}

