/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.LoggingExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.component.ComponentUtils;
import org.mule.runtime.core.internal.construct.FromFlowRejectedExecutionException;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.internal.routing.RoutingUtils;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class AsyncDelegateMessageProcessor
extends AbstractMessageProcessorOwner
implements Scope,
Initialisable,
Startable,
Stoppable {
    @Inject
    private MuleContext muleContext;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ProcessingStrategy processingStrategy;
    private Sink sink;
    private QueueBackpressureHandler backpressureHandler;
    private final MessageProcessorChainBuilder delegateBuilder;
    protected MessageProcessorChain delegate;
    private Scheduler reactorScheduler;
    protected String name;
    private Integer maxConcurrency;

    public AsyncDelegateMessageProcessor(MessageProcessorChainBuilder delegate) {
        this.delegateBuilder = delegate;
    }

    public AsyncDelegateMessageProcessor(MessageProcessorChainBuilder delegate, String name) {
        this.delegateBuilder = delegate;
        this.name = name;
    }

    @Override
    public void initialise() throws InitialisationException {
        Component rootContainer = ComponentUtils.getFromAnnotatedObject(this.componentLocator, this).orElse(null);
        if (rootContainer instanceof Pipeline) {
            if (this.maxConcurrency != null) {
                ProcessingStrategyFactory flowPsFactory = ((Pipeline)rootContainer).getProcessingStrategyFactory();
                if (flowPsFactory instanceof AsyncProcessingStrategyFactory) {
                    ((AsyncProcessingStrategyFactory)flowPsFactory).setMaxConcurrency(this.maxConcurrency);
                } else {
                    this.logger.warn("{} does not support 'maxConcurrency'. Ignoring the value.", (Object)flowPsFactory.getClass().getSimpleName());
                }
                this.processingStrategy = flowPsFactory.create(this.getMuleContext(), this.getLocation().getLocation());
            } else {
                ProcessingStrategyFactory flowPsFactory = ((Pipeline)rootContainer).getProcessingStrategyFactory();
                this.processingStrategy = flowPsFactory.create(this.getMuleContext(), this.getLocation().getLocation());
            }
        } else {
            this.processingStrategy = this.createDefaultProcessingStrategyFactory().create(this.getMuleContext(), this.getLocation().getLocation());
        }
        if (this.delegateBuilder == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("delegate message processor"), (Initialisable)this);
        }
        this.delegateBuilder.setProcessingStrategy(this.processingStrategy);
        this.delegate = this.delegateBuilder.build();
        LifecycleUtils.initialiseIfNeeded(this.delegate, this.getMuleContext());
        this.backpressureHandler = new QueueBackpressureHandler(this.schedulerService, () -> this.muleContext.getSchedulerBaseConfig(), this::dispatchEvent, this.name != null ? this.name : this.getLocation().getLocation());
        LifecycleUtils.initialiseIfNeeded(this.processingStrategy, this.muleContext);
        super.initialise();
    }

    protected ProcessingStrategyFactory createDefaultProcessingStrategyFactory() {
        return new DirectProcessingStrategyFactory();
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processingStrategy);
        LifecycleUtils.startIfNeeded(this.delegate);
        this.sink = this.processingStrategy.createSink(ComponentUtils.getFromAnnotatedObject(this.componentLocator, this).filter(c -> c instanceof FlowConstruct).orElse(null), this.processAsyncChainFunction());
        SchedulerConfig schedulerConfig = this.getMuleContext().getSchedulerBaseConfig().withName(this.name != null ? this.name : this.getLocation().getLocation());
        this.reactorScheduler = this.processingStrategy.isSynchronous() ? this.schedulerService.ioScheduler(schedulerConfig) : this.schedulerService.cpuLightScheduler(schedulerConfig);
        LifecycleUtils.startIfNeeded(this.backpressureHandler);
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        super.stop();
        FunctionalUtils.safely(() -> LifecycleUtils.stopIfNeeded(this.backpressureHandler));
        LifecycleUtils.disposeIfNeeded(this.sink, this.logger);
        this.sink = null;
        LifecycleUtils.stopIfNeeded(this.delegate);
        if (this.reactorScheduler != null) {
            this.reactorScheduler.stop();
            this.reactorScheduler = null;
        }
        LifecycleUtils.stopIfNeeded(this.processingStrategy);
    }

    @Override
    public void dispose() {
        super.dispose();
        LifecycleUtils.disposeIfNeeded(this.delegate, this.logger);
        LifecycleUtils.disposeIfNeeded(this.processingStrategy, this.logger);
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).cast(PrivilegedEvent.class).doOnNext(request -> {
            Flux asyncPublisher = Flux.just((Object)request).map(this::asyncEvent);
            if (TransactionCoordination.isTransactionActive() && !this.processingStrategy.isSynchronous()) {
                asyncPublisher = asyncPublisher.publishOn(Schedulers.fromExecutorService((ExecutorService)this.reactorScheduler));
            }
            asyncPublisher.map(event -> {
                try {
                    this.dispatchEvent((CoreEvent)event);
                }
                catch (FromFlowRejectedExecutionException free) {
                    this.backpressureHandler.handleBackpressure((CoreEvent)event);
                }
                return event;
            }).subscribe(Operators.requestUnbounded());
        }).cast(CoreEvent.class);
    }

    private void dispatchEvent(CoreEvent event) {
        this.processingStrategy.checkBackpressureAccepting(event);
        this.sink.accept(event);
    }

    private CoreEvent asyncEvent(PrivilegedEvent event) {
        InternalEvent copy = (InternalEvent)PrivilegedEvent.builder(DefaultEventContext.child(event.getContext(), Optional.ofNullable(this.getLocation()), LoggingExceptionHandler.getInstance()), event).session(new DefaultMuleSession(event.getSession())).build();
        RoutingUtils.setSourcePolicyChildContext(copy, this.featureFlaggingService);
        return copy;
    }

    private ReactiveProcessor processAsyncChainFunction() {
        return innerPublisher -> Flux.from((Publisher)innerPublisher).doOnNext(this.fireAsyncScheduledNotification()).transform((Function)this.processingStrategy.onPipeline(this.scheduleAsync(this.delegate))).doOnNext(event -> {
            this.fireAsyncCompleteNotification((CoreEvent)event, null);
            ((BaseEventContext)event.getContext()).success((CoreEvent)event);
        }).subscriberContext(ctx -> ctx.put((Object)"recreateRouter", (Object)true)).doOnError(MessagingException.class, e -> {
            this.fireAsyncCompleteNotification(e.getEvent(), (MessagingException)((Object)((Object)e)));
            ((BaseEventContext)e.getEvent().getContext()).error((Throwable)((Object)e));
        }).doOnError(throwable -> this.logger.warn("Error occurred during asynchronous processing at:" + this.getLocation().getLocation() + " . To handle this error include a <try> scope in the <async> scope.", throwable));
    }

    private ReactiveProcessor scheduleAsync(Processor delegate) {
        if (this.processingStrategy.isSynchronous()) {
            return publisher -> Flux.from((Publisher)publisher).transform((Function)delegate).subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.reactorScheduler));
        }
        return delegate;
    }

    private Consumer<CoreEvent> fireAsyncScheduledNotification() {
        return event -> this.muleContext.getNotificationManager().fireNotification((Notification)new AsyncMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, null, (Component)this), this.getLocation(), 1901));
    }

    private void fireAsyncCompleteNotification(CoreEvent event, MessagingException exception) {
        this.muleContext.getNotificationManager().fireNotification((Notification)new AsyncMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, (Exception)((Object)exception), (Component)this), this.getLocation(), 1902));
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.delegate);
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    protected List<Processor> getOwnedObjects() {
        return Collections.emptyList();
    }

    void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    private static class QueueBackpressureHandler
    implements Stoppable {
        private final BlockingQueue<CoreEvent> asyncQueue;
        private final Consumer<CoreEvent> eventDispatcher;
        private final LazyValue<Scheduler> queueDispatcherScheduler;
        private final AtomicReference<Future> executing = new AtomicReference();

        public QueueBackpressureHandler(SchedulerService schedulerService, Supplier<SchedulerConfig> schedulerConfigSupplier, Consumer<CoreEvent> eventDispatcher, String location) {
            this.asyncQueue = new LinkedBlockingQueue<CoreEvent>();
            this.eventDispatcher = eventDispatcher;
            this.queueDispatcherScheduler = new LazyValue(() -> {
                SchedulerConfig schedulerConfig = ((SchedulerConfig)schedulerConfigSupplier.get()).withName(location + " - queue dispatcher").withMaxConcurrentTasks(1);
                return schedulerService.customScheduler(schedulerConfig);
            });
        }

        private Future dispatchTask() {
            return ((Scheduler)this.queueDispatcherScheduler.get()).submit(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        CoreEvent queuedEvent = (CoreEvent)this.asyncQueue.peek();
                        if (queuedEvent != null) {
                            this.eventDispatcher.accept(queuedEvent);
                            this.asyncQueue.remove(queuedEvent);
                            continue;
                        }
                        AtomicReference<Future> atomicReference = this.executing;
                        synchronized (atomicReference) {
                            if (this.asyncQueue.size() == 0) {
                                this.executing.set(null);
                                return;
                            }
                        }
                    }
                    catch (FromFlowRejectedExecutionException free) {
                        Thread.yield();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleBackpressure(CoreEvent event) {
            this.asyncQueue.offer(event);
            AtomicReference<Future> atomicReference = this.executing;
            synchronized (atomicReference) {
                if (this.executing.get() == null) {
                    this.executing.set(this.dispatchTask());
                }
            }
        }

        public void stop() {
            this.queueDispatcherScheduler.ifComputed(Scheduler::stop);
            this.asyncQueue.clear();
        }
    }
}

