/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.notification;

import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;

public class ProfilingNotification<T extends ProfilingEventContext>
extends AbstractServerNotification {
    private static final int TEST_NOTIFICATION_ID = 2201;
    private static final int STARTING_FLOW_EXECUTION_ID = 2202;
    private static final int PS_SCHEDULING_FLOW_EXECUTION_ID = 2203;
    private static final int FLOW_EXECUTED_ID = 2204;
    private static final int PS_SCHEDULING_OPERATION_EXECUTION_ID = 2205;
    private static final int STARTING_OPERATION_EXECUTION_ID = 2206;
    private static final int OPERATION_EXECUTED_ID = 2207;
    private static final int PS_FLOW_MESSAGE_PASSING_ID = 2208;
    private static final int COMPONENT_PROFILING_EVENT_ID = 2209;
    private static final int STARTING_OPERATION_EXECUTION_EVENT_ID = 2210;
    private static final int OPERATION_EXECUTED_EVENT_ID = 2211;
    private static final int OPERATION_THREAD_RELEASE_EVENT_ID = 2212;
    private static final int TRANSACTION_START_ID = 2218;
    private static final int TRANSACTION_CONTINUE_ID = 2219;
    private static final int TRANSACTION_COMMIT_ID = 2220;
    private static final int TRANSACTION_ROLLBACK_ID = 2221;
    public static final String PROFILING_NAMESPACE_IDENTIFIER_SEPARATOR = ":";
    private final ProfilingEventType<T> profilingEventType;

    public ProfilingNotification(T profilingEventContext, ProfilingEventType<T> profilingEventType) {
        super(profilingEventContext, ProfilingNotification.getActionId((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(profilingEventType)));
        this.profilingEventType = profilingEventType;
    }

    public boolean isSynchronous() {
        return true;
    }

    public String getEventName() {
        return "ProfilingServerNotification";
    }

    public ProfilingEventType<T> getProfilingEventType() {
        return this.profilingEventType;
    }

    public static String getFullyQualifiedProfilingNotificationIdentifier(ProfilingEventType<?> profilingEventType) {
        return profilingEventType.getProfilingEventTypeNamespace() + PROFILING_NAMESPACE_IDENTIFIER_SEPARATOR + profilingEventType.getProfilingEventTypeIdentifier();
    }

    static {
        ProfilingNotification.registerAction((String)"test-namespace:test", (int)2201);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION), (int)2202);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION), (int)2203);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.FLOW_EXECUTED), (int)2204);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION), (int)2205);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.PS_STARTING_OPERATION_EXECUTION), (int)2206);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.PS_OPERATION_EXECUTED), (int)2207);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING), (int)2208);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.EXTENSION_PROFILING_EVENT), (int)2209);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION), (int)2210);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.OPERATION_EXECUTED), (int)2211);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.OPERATION_THREAD_RELEASE), (int)2212);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.TX_START), (int)2218);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.TX_CONTINUE), (int)2219);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.TX_COMMIT), (int)2220);
        ProfilingNotification.registerAction((String)ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.TX_ROLLBACK), (int)2221);
    }
}

