/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.rx;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.util.context.Context;

public class FluxSinkRecorder<T>
implements Consumer<FluxSink<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FluxSinkRecorder.class);
    private volatile FluxSinkRecorderDelegate<T> delegate = new NotYetAcceptedDelegate();
    private static final boolean PRINT_STACK_TRACES_ON_DROP = Boolean.getBoolean("mule.fluxSinkRecorder.printStackTracesOnDrop");
    private volatile String completionStackTrace = null;
    private volatile String acceptStackTrace = null;

    public Flux<T> flux() {
        return Flux.create((Consumer)this).subscriberContext(ctx -> Context.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(FluxSink<T> fluxSink) {
        if (PRINT_STACK_TRACES_ON_DROP) {
            FluxSinkRecorder fluxSinkRecorder = this;
            synchronized (fluxSinkRecorder) {
                this.acceptStackTrace = this.getStackTraceAsString();
            }
        }
        FluxSinkRecorderDelegate<FluxSink<T>> previousDelegate = this.delegate;
        this.delegate = new DirectDelegate<T>(fluxSink);
        previousDelegate.accept(fluxSink);
    }

    public FluxSink<T> getFluxSink() {
        return this.delegate.getFluxSink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next(T response) {
        if (PRINT_STACK_TRACES_ON_DROP) {
            FluxSinkRecorder fluxSinkRecorder = this;
            synchronized (fluxSinkRecorder) {
                if (this.completionStackTrace != null) {
                    LOGGER.warn("Event will be dropped {}\nCompletion StackTrace:\n{}\nAccept StackTrace:\n{}", new Object[]{response, this.completionStackTrace, this.acceptStackTrace});
                }
            }
        }
        this.delegate.next(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Throwable error) {
        if (PRINT_STACK_TRACES_ON_DROP) {
            FluxSinkRecorder fluxSinkRecorder = this;
            synchronized (fluxSinkRecorder) {
                this.completionStackTrace = this.getStackTraceAsString();
            }
        }
        this.delegate.error(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        if (PRINT_STACK_TRACES_ON_DROP) {
            FluxSinkRecorder fluxSinkRecorder = this;
            synchronized (fluxSinkRecorder) {
                this.completionStackTrace = this.getStackTraceAsString();
            }
        }
        this.delegate.complete();
    }

    private String getStackTraceAsString() {
        StackTraceElement[] stackTrace;
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            sb.append('\t').append(element).append('\n');
        }
        return sb.toString();
    }

    private static class DirectDelegate<T>
    implements FluxSinkRecorderDelegate<T> {
        private final FluxSink<T> fluxSink;

        DirectDelegate(FluxSink<T> fluxSink) {
            this.fluxSink = fluxSink;
        }

        @Override
        public void accept(FluxSink<T> t) {
        }

        @Override
        public FluxSink<T> getFluxSink() {
            return this.fluxSink;
        }

        @Override
        public void next(T response) {
            this.fluxSink.next(response);
        }

        @Override
        public void error(Throwable error) {
            this.fluxSink.error(error);
        }

        @Override
        public void complete() {
            this.fluxSink.complete();
        }
    }

    private static class NotYetAcceptedDelegate<T>
    implements FluxSinkRecorderDelegate<T> {
        private volatile FluxSink<T> fluxSink;
        private final List<Runnable> bufferedEvents = new ArrayList<Runnable>();

        private NotYetAcceptedDelegate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(FluxSink<T> fluxSink) {
            NotYetAcceptedDelegate notYetAcceptedDelegate = this;
            synchronized (notYetAcceptedDelegate) {
                this.fluxSink = fluxSink;
            }
            this.bufferedEvents.forEach(Runnable::run);
        }

        @Override
        public synchronized FluxSink<T> getFluxSink() {
            return this.fluxSink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void next(T response) {
            boolean present = true;
            NotYetAcceptedDelegate notYetAcceptedDelegate = this;
            synchronized (notYetAcceptedDelegate) {
                if (this.fluxSink == null) {
                    present = false;
                    this.bufferedEvents.add(() -> this.fluxSink.next(response));
                }
            }
            if (present) {
                this.fluxSink.next(response);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void error(Throwable error) {
            boolean present = true;
            NotYetAcceptedDelegate notYetAcceptedDelegate = this;
            synchronized (notYetAcceptedDelegate) {
                if (this.fluxSink == null) {
                    present = false;
                    this.bufferedEvents.add(() -> this.fluxSink.error(error));
                }
            }
            if (present) {
                this.fluxSink.error(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() {
            boolean present = true;
            NotYetAcceptedDelegate notYetAcceptedDelegate = this;
            synchronized (notYetAcceptedDelegate) {
                if (this.fluxSink == null) {
                    present = false;
                    this.bufferedEvents.add(() -> this.fluxSink.complete());
                }
            }
            if (present) {
                this.fluxSink.complete();
            }
        }
    }

    private static interface FluxSinkRecorderDelegate<T>
    extends Consumer<FluxSink<T>> {
        public FluxSink<T> getFluxSink();

        public void next(T var1);

        public void error(Throwable var1);

        public void complete();
    }
}

