/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import org.mule.runtime.api.util.DataSize;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.core.internal.streaming.bytes.ByteStreamingConstants;
import org.mule.runtime.extension.api.ExtensionConstants;

public final class FileStoreCursorStreamConfig {
    private final DataSize maxInMemorySize;
    private final int bucketSize;
    private final int bucketsCount;

    public static FileStoreCursorStreamConfig getDefault() {
        return new FileStoreCursorStreamConfig(new DataSize(1024, ExtensionConstants.DEFAULT_BYTE_STREAMING_BUFFER_DATA_UNIT));
    }

    public FileStoreCursorStreamConfig(DataSize maxInMemorySize) {
        int effectiveMaxInMemorySize = maxInMemorySize.toBytes();
        this.bucketSize = Math.min(ByteStreamingConstants.DEFAULT_BUFFER_BUCKET_SIZE, effectiveMaxInMemorySize);
        this.bucketsCount = Math.max(1, effectiveMaxInMemorySize / this.bucketSize);
        if (effectiveMaxInMemorySize % this.bucketSize > 0) {
            effectiveMaxInMemorySize = this.bucketsCount * this.bucketSize;
        }
        this.maxInMemorySize = new DataSize(effectiveMaxInMemorySize, DataUnit.BYTE);
    }

    public DataSize getMaxInMemorySize() {
        return this.maxInMemorySize;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public int getBucketsCount() {
        return this.bucketsCount;
    }
}

