/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.journal.queue;

import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.internal.util.journal.queue.LocalQueueTxJournalEntry;
import org.mule.runtime.core.internal.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.runtime.core.internal.util.queue.QueueProvider;
import org.mule.runtime.core.internal.util.queue.RecoverableQueueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTxQueueTransactionRecoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalTxQueueTransactionRecoverer.class);
    private final LocalTxQueueTransactionJournal localTxQueueTransactionJournal;
    private final QueueProvider queueProvider;

    public LocalTxQueueTransactionRecoverer(LocalTxQueueTransactionJournal localTxQueueTransactionJournal, QueueProvider queueProvider) {
        this.localTxQueueTransactionJournal = localTxQueueTransactionJournal;
        this.queueProvider = queueProvider;
    }

    public void recover() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing transaction recovery");
        }
        Multimap allEntries = this.localTxQueueTransactionJournal.getAllLogEntries();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found " + allEntries.size() + " txs to recover");
        }
        int txRecovered = 0;
        for (Integer txId : allEntries.keySet()) {
            Collection entries = allEntries.get((Object)txId);
            Object commitOrRollback = CollectionUtils.find((Collection)entries, object -> {
                LocalQueueTxJournalEntry logEntry = (LocalQueueTxJournalEntry)object;
                return logEntry.isCommit() || logEntry.isRollback();
            });
            if (commitOrRollback != null) continue;
            ++txRecovered;
            for (LocalQueueTxJournalEntry logEntry : entries) {
                if (logEntry.isRemove()) {
                    Serializable polledValue;
                    String queueName = logEntry.getQueueName();
                    RecoverableQueueStore queue = this.queueProvider.getRecoveryQueue(queueName);
                    if (queue.contains(polledValue = logEntry.getValue())) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("re-adding polled element that was not commited to queue " + queue.getName());
                    }
                    try {
                        queue.putNow(polledValue);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                }
                if (!logEntry.isAdd() && !logEntry.isAddFirst()) continue;
                Serializable offeredValue = logEntry.getValue();
                String queueName = logEntry.getQueueName();
                RecoverableQueueStore queue = this.queueProvider.getRecoveryQueue(queueName);
                if (!queue.contains(offeredValue)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("removing offer element that was not commited to queue " + queue.getName());
                }
                queue.remove(offeredValue);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Recovered " + txRecovered + " txs to recover");
        }
        this.localTxQueueTransactionJournal.clear();
    }
}

