/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.value;

import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.tooling.client.api.extension.model.parameter.ActingParameterModel;
import org.mule.tooling.client.internal.util.Preconditions;

public class ValuesResolverModel {
    public static final String METADATA_KEY = "metadataKey";
    public static final String CATEGORY = "category";
    public static final String VALUE_PROVIDER = "valueProvider";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String OPEN_PARAMS = "(";
    public static final String CLOSE_PARAMS = ")";
    public static final String PARAM_NAME_DELIMITER = "::";
    public static final String PARAM_SEPARATOR = ",";
    private final List<ActingParameterModel> parameters;
    private final boolean requiresConfiguration;
    private final boolean requiresConnection;
    private final boolean isOpen;
    private String resolverName;

    public static String metadataKeyResolverName(String category, String resolverName) {
        return METADATA_KEY + OPEN_PARAMS + CATEGORY + PARAM_NAME_DELIMITER + category + PARAM_SEPARATOR + NAME + PARAM_NAME_DELIMITER + resolverName + CLOSE_PARAMS;
    }

    public static String valueProviderResolverName(String providerId) {
        return VALUE_PROVIDER + OPEN_PARAMS + ID + PARAM_NAME_DELIMITER + providerId + CLOSE_PARAMS;
    }

    public ValuesResolverModel(List<ActingParameterModel> parameters, boolean requiresConfiguration, boolean requiresConnection, boolean isOpen, String resolverName) {
        Preconditions.checkNotNull(parameters, "'parameters' can't be null");
        this.isOpen = isOpen;
        this.parameters = parameters;
        this.requiresConfiguration = requiresConfiguration;
        this.requiresConnection = requiresConnection;
        this.resolverName = resolverName;
    }

    protected ValuesResolverModel() {
        this.isOpen = false;
        this.parameters = null;
        this.requiresConfiguration = false;
        this.requiresConnection = false;
        this.resolverName = null;
    }

    public List<ActingParameterModel> getParameters() {
        return this.parameters;
    }

    public boolean requiresConfiguration() {
        return this.requiresConfiguration;
    }

    public boolean requiresConnection() {
        return this.requiresConnection;
    }

    public String getResolverName() {
        return this.resolverName;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValuesResolverModel that = (ValuesResolverModel)o;
        return new EqualsBuilder().append(this.parameters, that.parameters).append(this.requiresConfiguration, that.requiresConfiguration).append(this.requiresConnection, that.requiresConnection).append(this.isOpen, that.isOpen).append((Object)this.resolverName, (Object)that.resolverName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.parameters).append(this.requiresConfiguration).append(this.requiresConnection).append(this.isOpen).append((Object)this.resolverName).toHashCode();
    }

    public String toString() {
        return "ValuesResolverModel{resolverName='" + this.resolverName + '\'' + ", requiresConfiguration=" + this.requiresConfiguration + ", requiresConnection=" + this.requiresConnection + ", isOpen=" + this.isOpen + ", parameters=" + this.parameters + '}';
    }
}

