/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.domain.runtime.configuration;

import java.util.Objects;

public class RemoteRepositoryInfo {
    private String id;
    private String url;
    private boolean hasAuthentication = false;

    public RemoteRepositoryInfo(String id, String url, boolean hasAuthentication) {
        this.id = id;
        this.url = url;
        this.hasAuthentication = hasAuthentication;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isHasAuthentication() {
        return this.hasAuthentication;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteRepositoryInfo that = (RemoteRepositoryInfo)o;
        if (this.hasAuthentication != that.hasAuthentication) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.url.equals(that.url);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + (this.hasAuthentication ? 1 : 0);
        return result;
    }

    public static class RemoteRepositoryInfoBuilder {
        private String id;
        private String url;
        private boolean hasAuthentication;

        public RemoteRepositoryInfoBuilder withId(String id) {
            Objects.requireNonNull(id, "id cannot be null");
            this.id = id;
            return this;
        }

        public RemoteRepositoryInfoBuilder withUrl(String url) {
            Objects.requireNonNull(url, "remoteRepositoryUrl cannot be null");
            this.url = url;
            return this;
        }

        public RemoteRepositoryInfoBuilder withAuthentication() {
            this.hasAuthentication = true;
            return this;
        }

        public RemoteRepositoryInfo build() {
            return new RemoteRepositoryInfo(this.id, this.url, this.hasAuthentication);
        }
    }
}

