/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service.detection;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.service.detection.PolicyChangeInspector;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.ChangeType;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyAdded;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyRemoved;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class PolicySetChangeInspector {
    private PolicyChangeInspector changeInspector = new PolicyChangeInspector();

    public List<ChangeType> detectChanges(List<PolicyDeploymentStatus> currentStatusList, List<PolicyDefinition> newDefinitions) {
        LinkedList<ChangeType> changes = new LinkedList<ChangeType>();
        for (PolicyDefinition definition : newDefinitions) {
            Optional<PolicyDeploymentStatus> currentStatus = currentStatusList.stream().filter(status -> this.samePolicyId((PolicyDeploymentStatus)status, definition)).findFirst();
            if (!currentStatus.isPresent()) {
                changes.add(new PolicyAdded(definition));
                continue;
            }
            changes.add(this.changeInspector.detectChange(currentStatus.get(), definition));
        }
        this.policiesToRemove(currentStatusList, newDefinitions).forEach(changes::add);
        return changes;
    }

    private Stream<ChangeType> policiesToRemove(List<PolicyDeploymentStatus> currentStatuses, List<PolicyDefinition> policySet) {
        return currentStatuses.stream().filter(status -> policySet.stream().noneMatch(policyDefinition -> this.samePolicyId((PolicyDeploymentStatus)status, (PolicyDefinition)policyDefinition))).map(status -> status.getLatestPolicyStatus().getPolicyDefinition()).map(PolicyRemoved::new);
    }

    private boolean samePolicyId(PolicyDeploymentStatus status, PolicyDefinition policyDefinition) {
        return policyDefinition.getId().equals(status.getLatestPolicyStatus().getPolicyDefinition().getId());
    }
}

