/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore.expiry;

import com.hazelcast.internal.util.TimeStripUtil;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;

public class ExpiryMetadataImpl
implements ExpiryMetadata {
    private int ttl;
    private int maxIdle;
    private int lastUpdateTime;
    private volatile int expirationTime;

    public ExpiryMetadataImpl() {
    }

    public ExpiryMetadataImpl(long ttl, long maxIdle, long expirationTime, long lastUpdateTime) {
        this.setTtl(ttl);
        this.setMaxIdle(maxIdle);
        this.setExpirationTime(expirationTime);
        this.setLastUpdateTime(lastUpdateTime);
    }

    @Override
    public long getTtl() {
        return ExpirationTimeSetter.toMillis(this.ttl);
    }

    @Override
    public int getRawTtl() {
        return this.ttl;
    }

    @Override
    public ExpiryMetadata setTtl(long ttl) {
        this.ttl = ExpirationTimeSetter.toSeconds(ttl);
        return this;
    }

    @Override
    public ExpiryMetadata setRawTtl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public long getMaxIdle() {
        return ExpirationTimeSetter.toMillis(this.maxIdle);
    }

    @Override
    public int getRawMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public ExpiryMetadata setMaxIdle(long maxIdle) {
        this.maxIdle = ExpirationTimeSetter.toSeconds(maxIdle);
        return this;
    }

    @Override
    public ExpiryMetadata setRawMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    @Override
    public long getExpirationTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.expirationTime);
    }

    @Override
    public int getRawExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public ExpiryMetadata setExpirationTime(long expirationTime) {
        this.expirationTime = TimeStripUtil.stripBaseTime(expirationTime);
        return this;
    }

    @Override
    public ExpiryMetadata setRawExpirationTime(int expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Override
    public long getLastUpdateTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.lastUpdateTime);
    }

    @Override
    public int getRawLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public ExpiryMetadata setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = TimeStripUtil.stripBaseTime(lastUpdateTime);
        return this;
    }

    @Override
    public ExpiryMetadata setRawLastUpdateTime(int lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    public String toString() {
        return "ExpiryMetadataImpl{ttl=" + this.getTtl() + ", maxIdle=" + this.getMaxIdle() + ", expirationTime=" + this.getExpirationTime() + ", lastUpdateTime=" + this.getLastUpdateTime() + '}';
    }
}

