/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.metadata.internal;

import java.io.File;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.module.soapkit.metadata.api.Notifier;
import org.mule.module.soapkit.metadata.api.ResourceLoader;
import org.mule.wsdl.parser.WsdlParser;
import org.mule.wsdl.parser.model.WsdlModel;

public class WsdlHandler {
    private final ResourceLoader resourceLoader;
    private final Notifier notifier;

    public WsdlHandler(ResourceLoader resourceLoader, Notifier notifier) {
        this.resourceLoader = resourceLoader;
        this.notifier = notifier;
    }

    public Optional<WsdlModel> getWsdlModel(String wsdlLocation) {
        try {
            URL resource;
            URL uRL = resource = "/".equals(File.separator) ? this.resourceLoader.getResource(wsdlLocation) : this.resourceLoader.getResource(wsdlLocation.replace("\\", "/"));
            if (resource != null) {
                return Optional.of(WsdlParser.Companion.parse(resource.toString()));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            String msg = String.format("Something went wrong when parsing the wsdl file %s", StringUtils.isBlank((CharSequence)e.getMessage()) ? " for [" + wsdlLocation + "]" : ", full message " + e.getMessage());
            this.notifier.error(msg);
            return Optional.empty();
        }
    }
}

