/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.buffer;

import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import java.util.List;
import org.mule.runtime.api.bulk.BulkItem;
import org.mule.runtime.api.bulk.BulkOperationResult;
import org.mule.runtime.core.api.event.CoreEvent;

public class PartialErrorMatcher {
    private BatchStep step;

    public PartialErrorMatcher(BatchStep step) {
        this.step = step;
    }

    public void match(List<Record> records, CoreEvent event) {
        BulkOperationResult<?> result = this.getOperationResult(event);
        if (result != null) {
            this.doMatch(records, result);
        }
    }

    private <T> void doMatch(List<Record> records, BulkOperationResult<T> result) {
        int resultSize;
        List recordResults = result.getItems();
        int recordsSize = records.size();
        if (recordsSize != (resultSize = recordResults.size())) {
            throw new IllegalStateException(String.format("Could not do partial error matching. Got %d records from batch but %d from bulkOperationResults. Sizes should match. This is probably a bug in the Cloud Connector", recordsSize, resultSize));
        }
        int i = 0;
        while (i < recordsSize) {
            BulkItem recordResult = (BulkItem)recordResults.get(i);
            if (!recordResult.isSuccessful()) {
                Record record = records.get(i);
                record.markAsFailedInStep(this.step, recordResult.getException());
            }
            ++i;
        }
    }

    private BulkOperationResult<?> getOperationResult(CoreEvent event) {
        Object payload = event.getMessage().getPayload().getValue();
        if (payload instanceof BulkOperationResult) {
            return (BulkOperationResult)payload;
        }
        return null;
    }
}

