/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license.wizard;

import com.nexes.wizard.WizardPanelDescriptor;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.wizard.Dialogs;
import de.schlichtherle.license.wizard.LicenseUninstalledEvent;
import de.schlichtherle.license.wizard.LicenseUninstalledListener;
import de.schlichtherle.license.wizard.Resources;
import de.schlichtherle.swing.Defaults;
import de.schlichtherle.swing.EnhancedButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;

public class UninstallPanel
extends JPanel {
    private final LicenseManager manager;
    private JTextArea prompt;
    private EnhancedButton uninstallButton;

    public UninstallPanel(LicenseManager licenseManager) {
        this.manager = licenseManager;
        this.initComponents();
    }

    private void initComponents() {
        this.prompt = new JTextArea();
        this.uninstallButton = new EnhancedButton();
        this.setLayout(new GridBagLayout());
        this.prompt.setEditable(false);
        this.prompt.setFont(Defaults.labelBoldFont);
        this.prompt.setLineWrap(true);
        this.prompt.setText(Resources.getString("UninstallPanel.prompt.text", new Object[]{this.manager.getLicenseParam().getSubject()}));
        this.prompt.setWrapStyleWord(true);
        this.prompt.setBorder(null);
        this.prompt.setOpaque(false);
        this.prompt.setPreferredSize(new Dimension(370, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.prompt, gridBagConstraints);
        this.uninstallButton.setText(Resources.getString("UninstallPanel.uninstallButton.text"));
        this.uninstallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UninstallPanel.this.uninstallButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.uninstallButton, gridBagConstraints);
    }

    private void uninstallButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.manager.uninstall();
            this.uninstallButton.setEnabled(false);
            this.fireLicenseUninstalled();
        }
        catch (Exception exception) {
            Dialogs.showMessageDialog(this, exception.getLocalizedMessage(), Resources.getString("UnInstallPanel.failure.title"), 0);
        }
    }

    public synchronized void addLicenseUninstalledListener(LicenseUninstalledListener licenseUninstalledListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(LicenseUninstalledListener.class, licenseUninstalledListener);
    }

    public synchronized void removeLicenseUninstalledListener(LicenseUninstalledListener licenseUninstalledListener) {
        this.listenerList.remove(LicenseUninstalledListener.class, licenseUninstalledListener);
    }

    protected void fireLicenseUninstalled() {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        LicenseUninstalledEvent licenseUninstalledEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$de$schlichtherle$license$wizard$LicenseUninstalledListener == null ? UninstallPanel.class$("de.schlichtherle.license.wizard.LicenseUninstalledListener") : class$de$schlichtherle$license$wizard$LicenseUninstalledListener)) continue;
            if (licenseUninstalledEvent == null) {
                licenseUninstalledEvent = new LicenseUninstalledEvent(this);
            }
            ((LicenseUninstalledListener)objectArray[i + 1]).licenseUninstalled(licenseUninstalledEvent);
        }
    }

    public static class Descriptor
    extends WizardPanelDescriptor {
        public static final String IDENTIFIER = "UNINSTALL_PANEL";

        public Descriptor(LicenseManager licenseManager) {
            this.setPanelDescriptorIdentifier(IDENTIFIER);
            UninstallPanel uninstallPanel = new UninstallPanel(licenseManager);
            this.setPanelComponent(uninstallPanel);
            uninstallPanel.addLicenseUninstalledListener(new LicenseUninstalledListener(this){
                private final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = descriptor;
                }

                public void licenseUninstalled(LicenseUninstalledEvent licenseUninstalledEvent) {
                    this.this$0.getWizardModel().setNextButtonEnabled(Boolean.TRUE);
                }
            });
        }

        public Object getNextPanelDescriptor() {
            return FINISH;
        }

        public Object getBackPanelDescriptor() {
            return "WELCOME_PANEL";
        }

        public void aboutToDisplayPanel() {
            ((UninstallPanel)this.getPanelComponent()).uninstallButton.setEnabled(true);
            this.getWizardModel().setNextButtonEnabled(Boolean.FALSE);
        }
    }
}

